package cn.com.duiba.activity.center.api.remoteservice.sign.system;

import cn.com.duiba.activity.center.api.dto.sign.system.SignOperatingDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/4/21.
 */
@AdvancedFeignClient
public interface RemoteSignOperatingService {
    /**
     * 签到活动入库
     *
     * @param dto
     * @return
     */
    DubboResult<Long> insert(SignOperatingDto dto);

    /**
     * 删除入库信息
     *
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteById(long id);

    /**
     * 更新入库信息
     *
     * @param dto
     * @return
     */
    DubboResult<Integer> updateByIdUnNULL(SignOperatingDto dto);

    /**
     * 根据Id查询
     * @param id
     * @return
     */
    DubboResult<SignOperatingDto> find(Long id);

    /**
     * 查询appId对应的入库活动
     *
     * @param appId
     * @return
     */
    DubboResult<List<SignOperatingDto>> findByAppId(long appId);

    /**
     * 根据tb_sign_operating唯一索引反查入库信息
     * @param appId
     * @param signActivityId
     * @return
     */
    DubboResult<SignOperatingDto> findByAppIdAndActivityId(long appId, long signActivityId);

    /**
     * 统计参与活动的app数量
     * @param signActivityId
     * @return
     */
    DubboResult<Integer> countAppByActivityId(long signActivityId);

}
