package cn.com.duiba.activity.center.api.remoteservice.plugin;

import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.flow.FlowFeatureDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginParticipateStatusDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginVistDto;
import cn.com.duiba.activity.center.api.enums.PopupTimeAreaEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityPluginService.java <br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2016年10月13日 下午4:09:53
 * @parameter
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteActivityPluginService {

    /**
     * findActivityPluginInfoList:(这里用一句话描述这个方法的作用). <br/>
     * 查询插件活动list
     *
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList();

    /**
     * findBrickById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询签到皮肤
     *
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<PopupActivityBrickDto> findBrickById(Long id);

    /**
     * findBrickById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询签到皮肤
     *
     * @param ids
     * @return
     * @since JDK 1.6
     */
    DubboResult<Map<Long,PopupActivityBrickDto>> findBrickByIds(List<Long> ids);

    /**
     * findById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询插件活动
     *
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<ActivityPluginDto> findById(Long id);

    /**
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id开启插件活动配置
     *
     * @param id
     * @param value
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateStatus(Long id, Integer value);

    /**
     * 编辑插件活动配置
     */
    DubboResult<Integer> updateActivityPluginInfo(Long id, Integer activityType);

    /**
     * 根据Id查询插件活动
     *
     * @return 操作结果
     */
    DubboResult<ActivityPluginVistDto> findByActivityIdAndType(Long id, Integer activityType);

    /**
     * 根据流量规则获取插件列表
     *
     * @param dto
     * @return
     */
    DubboResult<List<ActivityPluginDto>> findByFlowRule(FlowFeatureDto dto);

    /**
     * findBrickByIdNoCache:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询皮肤
     * 此接口不做缓存
     * 需要缓存可以选择findBrickById
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<PopupActivityBrickDto> findBrickByIdNoCache(Long id);

    /**
     * 根据皮肤id查询皮肤MD5
     * @param id
     * @return
     */
    DubboResult<String> findMd5ById(Long id);

    /**
     * 首页弹层监控
     * 按照00:30 -- 06:30,06:30 -- 12:30,12:30 -- 18:30,18:30 -- 00:30,四个时间段划分
     * 将appId存入对应集合中，数据只保存12小时
     * 集合数据通过 findAppMarkForPopup 接口获取
     * @see #findAppMarkForPopup(PopupTimeAreaEnum)
     */
    void addAppMarkForPopup(Long appId);

    /**
     * 根据时间段枚举类型获取对应的数据
     * @see PopupTimeAreaEnum
     * @param popupTimeAreaEnum
     * @return
     */
    Set<Long> findAppMarkForPopup(PopupTimeAreaEnum popupTimeAreaEnum);

    /**
     * 根据id list获取插件列表
     *
     * @param ids
     * @return
     */
    List<ActivityPluginDto> findByIds(List<Long> ids);

    /**
     * 根据插件id列表，判断用户是否参与过这些插件
     * 注：免费使用，不包含扣积分使用
     */
    List<ActivityPluginParticipateStatusDto> checkUsedPlugins(List<Long> plugins, Long consumerId);
}
