package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetConfigDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/05/02
 */
@AdvancedFeignClient
public interface RemoteBackendBetConfigService {
    /**
     * 新增投注活动配置
     * @param betConfigDto 投注活动配置参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(BetConfigDto betConfigDto) throws BizException;

    /**
     * 更新投注活动
     * @param betConfigDto 需要更新的投注活动配置
     * @return 是否成功
     * @throws BizException bizException
     */
    Integer update(BetConfigDto betConfigDto) throws BizException;

    /**
     * 分页获取活动列表
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @return Page<BetConfigDto>
     * @throws BizException bizException
     */
    Page<BetConfigDto> list(Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 获取活动配置详情
     * @param id key
     * @return betConfigDto
     * @throws BizException bizException
     */
    BetConfigDto findById(Long id) throws BizException;
}
