package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author jiaozi
 * @date 18/3/9
 * @description
 */
@AdvancedFeignClient
public interface RemoteCollectCardsParameterService {

	/**
	 * 获取需要获取的后几张卡片数量
	 */
	Integer getNeedNumber(Long activityId);

	/**
	 * 保存需要获取的后几张卡片数量
	 */
	void saveNeedNumber(Long activityId, Integer number);

	/**
	 * 获取发放概率
	 */
	Double getPercent(Long activityId);

	/**
	 * 保存发放概率
	 */
	void savePercent(Long activityId, Double percent);

	/**
	 * 获取每张卡片单个用户发放上限
	 */
	Integer getLimitMax(Long activityId);

	/**
	 * 保存每张卡片单个用户发放上限
	 */
	void saveLimitMax(Long activityId, Integer limit);
}
