package cn.com.duiba.activity.center.api.remoteservice.sign.system;

import cn.com.duiba.activity.center.api.dto.sign.system.SignSkinTemplateDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author liugq
 * @date created in 2018/4/10
 * @description: 签到皮肤模板(管理后台使用服务)
 */
@AdvancedFeignClient
public interface RemoteSignSkinTemplateBackendService {

    /**
     * 主键查询
     * @param id
     * @return
     */
    SignSkinTemplateDto findById(Long id);

    /**
     * 查询总数
     * @return
     */
    int countTotal();

    /**
     *
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<SignSkinTemplateDto> pageQuery(int pageNum,int pageSize);

    /**
     * 插入
     */
    Long insert(SignSkinTemplateDto dto);

    /**
     * 保存
     */
    Integer save(SignSkinTemplateDto dto);

}
