package cn.com.duiba.activity.center.api.dto.plugin;

import cn.com.duiba.activity.center.api.enums.PluginJoinVerificyModeEnum;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * ClassName:ActivityPluginDto.java <br/>
 * @author  gey
 * @date 创建时间：2016年10月11日 下午7:26:04 
 * @version 1.0
 * @parameter
 * @since   JDK 1.6
 */
public class ActivityPluginDto implements Serializable {

	private static final long serialVersionUID = 626677009528542670L;
	public static final Integer SWITCHES_DIRECT = 0; // 定向发放
	public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品
	public static final Integer SWITCHES_ANTICHEAT_LIMIT_RULE = 2; // 开启直充类奖品防刷

	/**
	 * 多皮肤模式开关，开启多皮肤模式时，通过智能算法推荐配置的多个皮肤中的最优皮肤
	 */
	public static final int SWITCHES_MULTI_SKINS_MODE = 3;

	/**
	 * 是否开启参与资格校验
	 */
	public static final int SWITCHES_JOIN_VERIFICY = 4;

	/**
	 * 是否记录参与人数
	 */
	public static final int SWITCHES_RECORD_JOIN_NUM = 5;
	/**
	 * 是否支持扣积分使用
	 */
	public static final int SWITCHES_DEDUCTION_CREDITS = 6;

	/**
	 * 是否打开活动联接开关
	 */
	public static final int SWITCHES_DUIBA_RELATE = 7;

	public static final int STATUS_OPEN = 1; // 开启且可见
	public static final int STATUS_CLOSE_SHOW = 2; // 关闭且可见
	public static final int STATUS_CLOSE = 3; // 关闭不可见
	public static final int STATUS_AUTO_OPENING = 4; // 关闭不可见，但即将自动上架

	/**
	 * 删除态
	 */
	public static final int DELETED = 1;

	public static final int SIGN_TYPE_FIRST = 0; // 活动有效期内首次登陆
	public static final int SIGN_TYPE_EVERYFIRST = 1; // 活动有效期内每天首次登陆
	public static final int SIGN_TYPE_EVERYTIME = 2; // 有效期内每次访问
	public static final int SIGN_TYPE_NEW_MEMBER = 3; // 新人礼包
	public static final int SIGN_TYPE_NO_LOGIN = 4; // 未登录用户访问
	public static final int SIGN_TYPE_EXIT = 5; // 退出首页

	public static final String PLUGDRAW = "plugdraw"; //插件式抽奖工具 
	public static final String PLUGIN = "plugin"; //插件弹层
	//拓展字段的key
	//活动策划
	public static final String CREATER_USER="create_user";
	//视觉策划
	public static final String PLOTTER_USER="plotter_user";
	/** 多皮肤中配置的皮肤 */
	public static final String MULTI_SKIN_IDS = "multiSkinIds";
	/**参与资格校验模式**/
	public static final String JOIN_VERIFICY_MODE = "joinVerificyMode";
	/**排行榜验证参数**/
	/**排行榜id**/
	public static final String NGAME_MUTI_RANK_BASE_CONFIG_ID = "ngameRankBaseId";
	/**排行榜排名  1226改成区间形式 1，2**/
	public static final String NGAME_MUTI_RANK_AREA = "ngameRankArea";
	/**综合分数**/
	public static final String NGAME_MUTI_RANK_SCORE = "ngameRankScore";
	/**兼容老数据**/
	public static final String NGAME_MUTI_RANK_TOP = "ngameRankTop";
	/**奖项排行榜验证参数**/
	/**奖项排行榜id**/
	public static final String OPTION_RANK_BASE_CONFIG_ID = "optionRankBaseId";
	/**奖项排行榜排名  1,2**/
	public static final String OPTION_RANK_AREA = "optionRankArea";

	/** 解锁记录验证 起始时间 */
	public static final String UNLOCKING_RECORD_START_TIME = "unlockingStartTime";
	/** 解锁记录验证 结束时间 */
	public static final String UNLOCKING_RECORD_END_TIME = "unlockingEndTime";

	/**爱奇艺打call专用校验**/
	/**活动id**/
	public static final String DO_CALL_ACTIVITY_ID = "dActivityId";
	/**明星编号**/
	public static final String DO_CALL_STAR_CODE = "dStarCode";
	/**最低分数**/
	public static final String DO_CALL_MORE_THAN_SCORE = "dScore";

	/**转转活动专用校验**/
	/**活动id**/
	public static final String FRIEND_POINTS_ACTIVITY_ID = "friendPointActId";
	/**需要解锁的好友力值**/
	public static final String FRIEND_POINTS_VALUE = "friendPointValue";

	/* 游戏昨日排行榜校验 2018-04-11 huweiwei */
	/** 游戏id */
	public static final String N_GAME_ID = "nGameId";
	/** 排名限制 */
	public static final String RANK_LIMIT = "rankLimit";
	/* 游戏昨日排行榜校验 2018-04-11 huweiwei */

	private Long id;
	//皮肤id
	private Long brickId;
	//标题
	private String title;
	//签到规则描述
	private String ruleDescription;
	//概率说明
	private String rateDescription;
	//应用场景 首页：0，活动自页面：1，主会场：2，活动自页面：3 此时 url 才存值
	private String scenarios;
	//trigger_time
	private String triggerTime;
	//触发事件
	private Integer signType;
	//状态（0：关闭，1：开启），默认为0	not null
	private Integer status;

	/**
	 * 是否删除
	 */
	private Integer deleted;

	//位运算标识
	private Integer switches;
	//定时自动下架日期
	private Date autoOffDate;
	//标签
	private String tag;
	//触发结果  1：直接发奖  2  跳转页面
	private Integer triggerTpye;
	//跳转url
	private String triggerUrl;
	// 参与次数限制
	private Integer limitCount;
	/**
	 * 参与类型（0，每天；1，永久；2，每周；3，每月）
	 * @see cn.com.duiba.activity.center.api.enums.LimitScopeEnum
	 */
	private Integer limitScope;
	// 插件活动的类型
	private String subType;
	// 退出间隔天数
	private Integer exitDays;
	//定时自动上架日期
	private Date autoOnDate;
	//关联活动类型
	private String activityRelate;
	//关联活动id
	private Long activityId;

	private Boolean hiddenForDeveloper;

	/** 库存预警通知邮件地址 */
	private String notifyEmail;

	/** 积分价值 **/
	private Integer creditsPrice;

	//拓展字段
	private String extJson;
	//投放渠道,发放福袋使用
	private Integer channelType;

	public List<Long> getMultiSkinList(){
		List<Long> skinIdList = new ArrayList<>();
		if(StringUtils.isBlank(extJson)){
			return skinIdList;
		}
		JSONObject json = JSONObject.parseObject(extJson);
		String skinIdStr = json.getString(MULTI_SKIN_IDS);
		if(StringUtils.isBlank(skinIdStr)){
			return skinIdList;
		}
		return JSONArray.parseArray(skinIdStr, Long.class);
	}

	/**
	 * 获取当前插件的校验类型
	 * @return
	 */
	public PluginJoinVerificyModeEnum getVerificyType(){
		if(StringUtils.isBlank(extJson)){
			return null;
		}
		JSONObject json = JSONObject.parseObject(extJson);
		String mode = json.getString(JOIN_VERIFICY_MODE);
		if(!org.apache.commons.lang3.StringUtils.isNumeric(mode)){
			return null;
		}
		return PluginJoinVerificyModeEnum.getVerificyModeByCode(Integer.valueOf(mode));
	}

	public Map<String,String> getVerificyParamByType(PluginJoinVerificyModeEnum mode){
		Map<String,String> params= Maps.newHashMap();
		if(mode == null){
			return params;
		}

		JSONObject json = JSONObject.parseObject(extJson);
		/**多游戏奖项校验**/
		if(mode.equals(PluginJoinVerificyModeEnum.NGAMEMUTIRANK)){
			params.put(NGAME_MUTI_RANK_BASE_CONFIG_ID,json.getString(NGAME_MUTI_RANK_BASE_CONFIG_ID));
			params.put(NGAME_MUTI_RANK_AREA,json.getString(NGAME_MUTI_RANK_AREA));
			params.put(NGAME_MUTI_RANK_TOP,json.getString(NGAME_MUTI_RANK_TOP));
		}else if(mode.equals(PluginJoinVerificyModeEnum.OPTIONNUMRANK)){
			params.put(OPTION_RANK_BASE_CONFIG_ID,json.getString(OPTION_RANK_BASE_CONFIG_ID));
			params.put(OPTION_RANK_AREA,json.getString(OPTION_RANK_AREA));
		}else if(PluginJoinVerificyModeEnum.NGAMEMUTIRANKSCORE.equals(mode)){
			params.put(NGAME_MUTI_RANK_BASE_CONFIG_ID,json.getString(NGAME_MUTI_RANK_BASE_CONFIG_ID));
			params.put(NGAME_MUTI_RANK_SCORE,json.getString(NGAME_MUTI_RANK_SCORE));
		}else if(PluginJoinVerificyModeEnum.DOCALLSCORE.equals(mode)){
			params.put(DO_CALL_ACTIVITY_ID,json.getString(DO_CALL_ACTIVITY_ID));
			params.put(DO_CALL_STAR_CODE,json.getString(DO_CALL_STAR_CODE));
			params.put(DO_CALL_MORE_THAN_SCORE,json.getString(DO_CALL_MORE_THAN_SCORE));
		}else if(PluginJoinVerificyModeEnum.FRIEND_POINTS.equals(mode)){
			params.put(FRIEND_POINTS_ACTIVITY_ID,json.getString(FRIEND_POINTS_ACTIVITY_ID));
			params.put(FRIEND_POINTS_VALUE,json.getString(FRIEND_POINTS_VALUE));
		}

		return params;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public Integer getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(Integer limitScope) {
		this.limitScope = limitScope;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}

	public Date getAutoOnDate() {
		return autoOnDate;
	}

	public void setAutoOnDate(Date autoOnDate) {
		this.autoOnDate = autoOnDate;
	}

	public String getActivityRelate() {
		return activityRelate;
	}

	public void setActivityRelate(String activityRelate) {
		this.activityRelate = activityRelate;
	}

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getBrickId() {
		return brickId;
	}
	public void setBrickId(Long brickId) {
		this.brickId = brickId;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getRuleDescription() {
		return ruleDescription;
	}
	public void setRuleDescription(String ruleDescription) {
		this.ruleDescription = ruleDescription;
	}
	public String getRateDescription() {
		return rateDescription;
	}
	public void setRateDescription(String rateDescription) {
		this.rateDescription = rateDescription;
	}
	public String getScenarios() {
		return scenarios;
	}
	public void setScenarios(String scenarios) {
		this.scenarios = scenarios;
	}
	public String getTriggerTime() {
		return triggerTime;
	}
	public void setTriggerTime(String triggerTime) {
		this.triggerTime = triggerTime;
	}
	public Integer getSignType() {
		return signType;
	}
	public void setSignType(Integer signType) {
		this.signType = signType;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getSwitches() {
		return switches;
	}
	public void setSwitches(Integer switches) {
		this.switches = switches;
	}
	public Date getAutoOffDate() {
		return autoOffDate;
	}
	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public Integer getExitDays() {
		return exitDays;
	}

	public void setExitDays(Integer exitDays) {
		this.exitDays = exitDays;
	}

	/**
	 *
	 * openSwitch:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param s
	 * @since JDK 1.6
	 */
	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	/**
	 *
	 * closeSwitch:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param s
	 * @since JDK 1.6
	 */
	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public String getTag() {
		return tag;
	}
	public void setTag(String tag) {
		this.tag = tag;
	}
	public Integer getTriggerTpye() {
		return triggerTpye;
	}
	public void setTriggerTpye(Integer triggerTpye) {
		this.triggerTpye = triggerTpye;
	}
	public String getTriggerUrl() {
		return triggerUrl;
	}
	public void setTriggerUrl(String triggerUrl) {
		this.triggerUrl = triggerUrl;
	}

	/**
	 *
	 * isOpenSwitch:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param s
	 * @return
	 * @since JDK 1.6
	 */
	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}

	public Integer getDeleted() {
		return deleted;
	}

	public void setDeleted(Integer deleted) {
		this.deleted = deleted;
	}

	public Boolean getHiddenForDeveloper() {
		return hiddenForDeveloper;
	}

	public void setHiddenForDeveloper(Boolean hiddenForDeveloper) {
		this.hiddenForDeveloper = hiddenForDeveloper;
	}

	public String getExtJson() {
		return extJson;
	}

	public void setExtJson(String extJson) {
		this.extJson = extJson;
	}

	public String getNotifyEmail() {
		return notifyEmail;
	}

	public void setNotifyEmail(String notifyEmail) {
		this.notifyEmail = notifyEmail;
	}

	public Integer getCreditsPrice() {
		return creditsPrice;
	}

	public void setCreditsPrice(Integer creditsPrice) {
		this.creditsPrice = creditsPrice;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public Integer getChannelType() {
		return channelType;
	}

	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}
}
