package cn.com.duiba.activity.center.api.remoteservice.activity_floating;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.activity_floating.AbTestDto;
import cn.com.duiba.activity.center.api.dto.activity_floating.FloatingLayerDto;
import cn.com.duiba.activity.center.api.dto.activity_floating.FloatingLayerRelationDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by gey on 2017/08/03.
 * 
 * 管理员端接口
 */
@AdvancedFeignClient
public interface RemoteActivityFloatingLayerBackendService {

	/**
	 * 查询皮肤信息列表
	 * 
	 * @param paramMap     
	 *  参数包括   title   offset   max    需要分页 或者 按照标题 查询时  把 三个参数 赋值就可以 实现
	 * @return
	 */
	public DubboResult<List<FloatingLayerDto>> findFloatingLayerList(Map<String, Object> paramMap);
	
	/**
	 * 查询皮肤信息列表
	 * 
	 * @param floatingLayerId     
	 * @return
	 */
	public DubboResult<FloatingLayerDto> findById(Long floatingLayerId);
	
	/**
	 * 报错或者更新  中奖弹层皮肤信息
	 * 
	 * @param dto
	 * @return  1 表示成功  0 失败
	 */
	public DubboResult<Integer> saveOrUpdateFloatingLayer(FloatingLayerDto dto);
	
	/**
	 * 更新 皮肤关联关系
	 * 
	 * @param floatingLayerId  皮肤id
	 * @param relationTypes    类型
	 * @param relationIds      活动ids
	 * @param adminId           adminId
	 * 
	 * @return  1 表示成功  0 失败
	 */
	public DubboResult<Integer> saveOrUpdateFloatingLayerRelation(Long floatingLayerId,List<String> relationTypes,List<Long> relationIds,Long adminId);
	

	/**
	 * 更新Abtest 信息
	 * 
	 * @param id  ABtest Id
	 * @param abTesType      测试类型
	 * @param relationType   活动类型
	 * @param relationId     活动id
	 * @param abTestIds      皮肤ids
	 * @param adminId
	 * @return  1 表示成功  0 失败
	 */
	public DubboResult<Integer> saveOrUpdateAbTest(Long id,int abTesType, String relationType, Long relationId, List<Long> abTestIds ,Long adminId);
	
	/**
	 * 查询 abTest信息列表
	 * 
	 * @param paramMap     
	 * @return
	 */
	public DubboResult<List<AbTestDto>> findAbTestList();

	/**
	 * 根据皮肤id查询所有关联纪录
     */
	DubboResult<List<FloatingLayerRelationDto>> findRelationByFloatingId(Long id);

	/**
	 * 根据获取所有皮肤数量
	 */
	DubboResult<Integer> findFloatingLayerCount();

	/**
	 * 根据id获取AbTest信息
	 */
	DubboResult<AbTestDto> findAbTestById(Long id);

	/**
	 * 分页查询abRest
	 * @param params  offset:查询偏移量  max:分页大小
	 */
	DubboResult<List<AbTestDto>> findAbTestListPage(Map<String, Object> params);

	/**
	 * 获取abTest总记录数
     */
	DubboResult<Integer> findAbTestListCount();

	/**
	 * 修改abTest启用状态
	 */
	DubboResult<Integer> changeState(Long id, boolean isOn);

	/**
	 * 删除abTest
	 */
	DubboResult<Integer> deleteAbTest(Long id);

	/**
	 * 根据活动id,活动类型查询正在启用状态的abTest
	 */
	DubboResult<AbTestDto> findAbTestOpen(AbTestDto queryDto);
}
