package cn.com.duiba.activity.center.api.remoteservice.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsEditDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsListDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsStatusEnum;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 管理员后台 弹层活动 service
 */
@AdvancedFeignClient
public interface RemoteElasticGiftsBackendService {

    /**
     * 管理员后台,查询弹层活动分页列表
     * @param currentPage
     * @param pageSize
     * @param bizCode
     * @param elasticGiftsId
     * @param title
     * @param title4admin
     * @return
     */
    DubboResult<Page<ElasticGiftsListDto>> findElasticGiftsPage(Integer currentPage, Integer pageSize, ElasticGiftsBizCodeEnum bizCode, Long elasticGiftsId, String title4admin);

    /**
     * 管理员后台,更新弹层活动状态
     * @param elasticGiftsId
     * @param targetStatus
     * @return
     */
    DubboResult<Boolean> updateStatus(Long elasticGiftsId, ElasticGiftsStatusEnum targetStatus);

    /**
     * 根据弹层活动 id,获取参与的 appids
     * @param elasticGiftsId
     * @return
     */
    DubboResult<List<Long>> getAppIdsByElasticGiftsId(Long elasticGiftsId);

    /**
     * 根据 id 删除弹层活动
     * 删除弹层活动的时候,需要把对应的所有弹层活动项删除
     * 和 app 的关系不变
     * @param elasticGiftsId
     * @return
     */
    DubboResult<Boolean> delete(Long elasticGiftsId);

    /**
     * 保存弹层活动
     * @param elasticGiftsId
     * @param title4admin
     * @param bizCode
     * @param termIds
     * @return
     */
    DubboResult<Boolean> save(Long elasticGiftsId, String title4admin, ElasticGiftsBizCodeEnum bizCode, List<Long> termIds);

    /**
     * 根据 elasticGiftsId 获取对象
     * @param elasticGiftsId
     * @return
     */
    DubboResult<ElasticGiftsEditDto> getElasticGiftsById(Long elasticGiftsId);

    /**
     * 根据 text 模糊查询 id 和 title4admin
     * @param bizCode
     * @param text
     * @return
     */
    DubboResult<List<ElasticGiftsDto>> getElasticGiftsByText(ElasticGiftsBizCodeEnum bizCode, String text);
}
