package cn.com.duiba.activity.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/6/12.
 */
public class OperatingActivityOptionsDto implements Serializable{
    private static final long serialVersionUID = -5057749907647260233L;
    private Long id;
    private Long operatingActivityId;
    private String name;
    private Integer payload;
    private Long appItemId;
    private Long itemId;
    private String prizeType;
    private String facePrice;
    private String logo;
    private Integer remaining;
    private String rate;
    private Boolean hidden;
    private String description;
    private Integer limitCount;
    private Integer minComein;
    private Boolean deleted;
    private Date gmtCreate;
    private Date gmtModified;

    private Boolean valid;//数据库中不存在该字段
    private Boolean addrlimit;//数据库中不存在该字段
	private String  itemName;//数据库中不存在该字段

	/**
	 * 
	 * Creates a new instance of OperatingActivityOptionsDto.
	 *
	 */
    public OperatingActivityOptionsDto() {
        super();
    }

    /**
     * 
     * Creates a new instance of OperatingActivityOptionsDto.
     *
     * @param id
     */
    public OperatingActivityOptionsDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     * 
     * Creates a new instance of OperatingActivityOptionsDto.
     *
     * @param init4insert
     */
    public OperatingActivityOptionsDto(boolean init4insert) {
        if (init4insert) {
            hidden = false;
            deleted = false;
            gmtCreate = new Date();
            gmtModified = new Date();
        }
    }

    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(String facePrice) {
        this.facePrice = facePrice;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Integer getRemaining() {
        return remaining;
    }

    public void setRemaining(Integer remaining) {
        this.remaining = remaining;
    }

    public String getRate() {
        return rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public Integer getMinComein() {
        return minComein;
    }

    public void setMinComein(Integer minComein) {
        this.minComein = minComein;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Boolean getAddrlimit() {
        return addrlimit;
    }

    public void setAddrlimit(Boolean addrlimit) {
        this.addrlimit = addrlimit;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public String toString() {
        return "OperatingActivityOptionsDto{" +
                "id=" + id +
                ", operatingActivityId=" + operatingActivityId +
                ", name='" + name + '\'' +
                ", payload=" + payload +
                ", appItemId=" + appItemId +
                ", itemId=" + itemId +
                ", prizeType='" + prizeType + '\'' +
                ", facePrice='" + facePrice + '\'' +
                ", logo='" + logo + '\'' +
                ", remaining=" + remaining +
                ", rate='" + rate + '\'' +
                ", hidden=" + hidden +
                ", description='" + description + '\'' +
                ", limitCount=" + limitCount +
                ", minComein=" + minComein +
                ", deleted=" + deleted +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                ", valid=" + valid +
                ", addrlimit=" + addrlimit +
                '}';
    }
}
