package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 管理员后台操作 基础配置和游戏关联基础配置表
 * Created by sty on 12/9/17.
 */
@AdvancedFeignClient
public interface RemoteNgameMutiRankingBackendService {

    /**
     * 新增配置项
     * @param baseConfigName
     * @param duibaGameIds
     * @return
     */
    boolean insert(String baseConfigName,List<Long> duibaGameIds);



    /**
     *    根据一个列表查询已经在配置项中并且没有被删除的列表，不管是否开启
     *    管理员后台用，限制一个配置项增加的游戏数目，目前是20，也就是最多list允许20个
     * @param duibaNgameIds
     * @return
     */
    List<Long> findhasRelationNgameIdByNgameIds(List<Long> duibaNgameIds);

    /**
     * 更新配置项
     * @param baseConfigId
     * @param duibaGameIds
     * @return
     */
    boolean modify(Long baseConfigId,List<Long> duibaGameIds);

    /**
     * 根据一个列表查询已经在配置项中并且没有被删除的列表，不管是否开启
     * 管理员后台用，限制一个配置项增加的游戏数目，目前是20，也就是最多list允许20个(编辑)
     * @param duibaNgameIds
     * @param baseConfigId
     * @return
     */
    List<Long> findhasRelationNgameIdByNgameIdsForModify(List<Long> duibaNgameIds,Long baseConfigId);
}
