package cn.com.duiba.activity.center.api.remoteservice.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * 
 * ClassName: RemoteDuibaQuestionStockService <br/>
 * date: 2016年12月1日 下午2:48:11 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaQuestionStockService {

    /**
     * 
     * findRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param questionOptionId
     * @param type
     * @return
     * @since JDK 1.6
     */
	DuibaQuestionStockDto findRemaining(Long questionOptionId, String type);

	/**
	 * 
	 * findByQuestionOptionIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @return
	 * @since JDK 1.6
	 */
	List<DuibaQuestionStockDto> findByQuestionOptionIds(List<Long> list);

	//from QuestionAnswerStockServiceImpl in credits

	/**
	 * 
	 * consumeStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOptionId
	 * @param bizId
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void consumeStock(Long questionOptionId, String bizId) throws BusinessException;

	/**
	 * 
	 * paybackStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void paybackStock(String questionOrderId) throws BusinessException;

	//from DuibaQuestionStockServiceImpl in manager

	/**
	 * 
	 * updateStockByOptions:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param option
	 * @since JDK 1.6
	 */
	public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option);
	/**
	 * 
	 * updateStockByOptions:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param option
	 * @param old
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	@RequestMapping("/updateStockByOptions1")
	public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option, DuibaQuestionAnswerOptionsDto old) throws BusinessException;
}
