package cn.com.duiba.activity.center.api.remoteservice.guessredpacket;

import cn.com.duiba.activity.center.api.dto.guessredpacket.GuessRedPacketDto;
import cn.com.duiba.activity.center.api.params.GuessRedPacketParams;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @description:猜红包服务
 * @author: zhengwei
 * @date: 2018-07-26 11:55
 */
@AdvancedFeignClient
public interface RemoteGuessRedPacketService {
    /**
     * 查询红包信息
     * @param params
     * @return
     */
    List<GuessRedPacketDto> findRedPackets(GuessRedPacketParams params);

    /**
     * 添加猜中红包结果
     * @param guessRedPacketDto
     * @return
     */
    Long addRedPacket(GuessRedPacketDto guessRedPacketDto);

    /**
     * 更新红包领奖状态
     * @param id
     * @param status {@link cn.com.duiba.activity.center.api.enums.RedPacketRecordStatusEnum}
     * @return
     */
    boolean exchangeRedPacketStatus(Long id, Integer status);

    /**
     * 查询红包领奖状态
     * @param id
     * @return
     */
    Integer findRedPacketStatus(Long id);
}
