package cn.com.duiba.activity.center.api.remoteservice.betv2;

import cn.com.duiba.activity.center.api.dto.activity_order.ActivityOrderDto;
import cn.com.duiba.activity.center.api.dto.betv2.BetV2ConfigResultDto;
import cn.com.duiba.activity.center.api.dto.betv2.BetV2PopUpDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * RemoteBetV2ConfigService
 *
 * @author ChenXiangge
 * @date 27/06/2018
 */
@AdvancedFeignClient
public interface RemoteBetV2ConfigService {
    BetV2ConfigResultDto listByAppId(Long appId, Long consumerId, Integer pageNo, Integer pageSize) throws BizException;

    BetV2PopUpDto getConsumerPopUpInfo(Long appId, Long consumerId, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 扣积分成功后的逻辑
     * 1.增加选项次数，还有用户参与情况
     * 2.如果扣的积分为0，可以直接调用这个方法
     *
     * @param activityOrderDto
     */
    void afterCredits(ActivityOrderDto activityOrderDto);

    /**
     * 获取选项的投票次数
     *
     * @return key=optionId value=${betTimes}投票次数
     */
    List<Long> getBetTimes(List<String> redisKeys);

    void doDraw();
}
