package cn.com.duiba.activity.center.api.remoteservice.happycode;


import cn.com.duiba.activity.center.api.dto.happy_code.HappyCodePhaseDto;
import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.biz.tool.duiba.dto.page.PageQuery;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * Created by hww on 2017/12/5
 */
@AdvancedFeignClient
public interface RemoteHappyCodePhaseService {

    List<HappyCodePhaseDto> findByBasicIds(List<Long> basicId);

    Long insert(HappyCodePhaseDto happyCodePhaseDto);

    void deleteById(Long id);

    void updateBasicId(Long basicId, List<Long> phaseIds);

    HappyCodePhaseDto findByPhaseId(Long phaseId);

    List<HappyCodePhaseDto> findByPhaseIds(List<Long> phaseIds);

    List<HappyCodePhaseDto> findAllWaitOpenPhase();

    void openPrizeRandom(List<Long> phaseIds);

    boolean updateStatusToWaitOpenPrize(Long phaseId);

    boolean updateStatusToOpening(Long phaseId);

    int updateWinner(HappyCodePhaseDto phaseDto);

    List<HappyCodePhaseDto> findByEndDate(Date queryDate);

    List<HappyCodePhaseDto> findAllPhaseByNextPrizeDate();

    Integer updateNextPrizeTime(Long id, Date nextPrizeDate);

    void openPrizeRandomByType(List<Long> phaseIds, Integer lotteryType);

    /**
     * 更新期次号
     * @param id
     * @param phaseNumber
     * @return
     */
    HappyCodePhaseDto updatePhaseNumber(Long id, String phaseNumber);

    /**
     * 更新下一期配置
     * @param phase
     * @return
     */
    int updateNextPhase(HappyCodePhaseDto phase);

    /**
     * 根据matchIds获取赛事第一期的期次id
     * @param basicIds 赛事ids
     * @return
     */
    List<HappyCodePhaseDto> listFirstPhaseByBasicIds(List<Long> basicIds);

    /**
     * 获取赛事某一特定次序的期次
     * @param basicId
     * @param payload
     * @return
     */
    HappyCodePhaseDto getPhaseByBasicIdAndPayload(Long basicId, Integer payload);

    /**
     * 根据赛事id 及 payload 分页获取期次信息
     * 按照期次顺序倒序排列
     *
     * @param basicId
     * @param payload
     * @param page
     * @return
     */
    Page<HappyCodePhaseDto> findByPastPhaseByBasicIdAndPayload(Long basicId, Integer payload, PageQuery page);



}
