package cn.com.duiba.activity.center.api.remoteservice.newgamecenter;

import cn.com.duiba.activity.center.api.dto.newgamecenter.SeasonConfigDto;
import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/09/03
 */
@AdvancedFeignClient
public interface RemoteSeasonConfigBackendService {
    /**
     * 新增赛季配置
     * @param seasonConfigDto seasonConfigDto
     * @return id
     */
    Long insert(SeasonConfigDto seasonConfigDto);

    /**
     * 编辑赛季配置
     * @param seasonConfigDto seasonConfigDto
     * @return 影响的行数
     */
    Integer update(SeasonConfigDto seasonConfigDto);

    /**
     * 获取赛季配置详情
     * @param id 赛季配置id
     * @return SeasonConfigDto
     */
    SeasonConfigDto findById(Long id);

    /**
     * 分页获取赛季列表
     * @param gameCenterConfigId 游戏中心配置id
     * @param pageNo pageNo
     * @param pageSize pageSize
     * @return Page<SeasonConfigDto>
     */
    Page<SeasonConfigDto> list(Long gameCenterConfigId, Integer pageNo, Integer pageSize);
}
