package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterException;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 积分额外奖励枚举类型
 * Created by sty on 9/8/17.
 */
public enum SignCreditsBonusTypeEnum {

    DOUBLETIMES("double","积分翻倍"),
    CUSTOM("custom","自定义增加积分数");

    private String name;

    private String remark;


    SignCreditsBonusTypeEnum(String name,String remark){
        this.name=name;
        this.remark=remark;
    }

    private static Map<String,SignCreditsBonusTypeEnum> typeMap = new HashMap<>();
    static{
        for(SignCreditsBonusTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getName(),typeEnum);
        }
    }

    /**
     * 根据name获取类型，获取失败则抛出异常
     * @param name
     * @return
     */
    public static SignCreditsBonusTypeEnum getSignExtraBonusByCode(String name){
        if(StringUtils.isBlank(name) || !typeMap.containsKey(name)){
            throw new ActivityCenterException("不支持的签到额外奖励相应类型,name="+name);
        }
        return typeMap.get(name);
    }

    public String getName() {
        return name;
    }


    public String getRemark() {
        return remark;
    }

}
