package cn.com.duiba.activity.center.api.remoteservice.joingroup;

import cn.com.duiba.activity.center.api.dto.joingroup.JoinGroupItemDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 18/9/18 16:06
 * @description: 拼团活动商品
 */
@AdvancedFeignClient
public interface RemoteJoinGroupItemAppService {

	/**
	 * 按id查询活动商品配置
	 */
	JoinGroupItemDto getById(Long id);

	/**
	 * 批量查询活动商品配置
	 */
	List<JoinGroupItemDto> getByIds(List<Long> ids);

	/**
	 * 商品剩余数量-1
	 */
	Integer modifyToSubRemaining(Long joinGroupItemId);

	/**
	 * 商品剩余数量增加
	 */
	Integer modifyToAddRemaining(Long joinGroupItemId, Integer number);
}
