package cn.com.duiba.activity.center.api.remoteservice.sign;

import cn.com.duiba.activity.center.api.dto.sign.SignInfoDto;
import cn.com.duiba.activity.center.api.dto.sign.SignStaticsDto;
import cn.com.duiba.activity.center.api.params.SignInfoQueryParam;
import cn.com.duiba.activity.center.api.params.SignStaticsQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 签到统计信息
 * Created by xiaoxuda on 2017/5/31.
 */
@AdvancedFeignClient
public interface RemoteSignStaticsService {
    /**
     * 根据用户ID、签到数据来源、来源关联ID查询签到统计信息
     * @param param
     * @return
     */
    SignStaticsDto findSignStaticsByUK(SignStaticsQueryParam param);


    /**
     * 获取用户当前签到信息
     * @param param
     * @return
     */
    SignInfoDto getSignInfoByConsumer(SignInfoQueryParam param);
}
