/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.enums;

import java.util.Calendar;
import java.util.Date;

public enum PopupTimeAreaEnum {
    FIRST("00:30-06:30", 0),
    SECOND("06:30-12:30", 1),
    THIRD("12:30-18:30", 2),
    FOURTH("18:30-00:30", 3);

    private static long FIRST_NODE;
    private static long SECOND_NODE;
    private static long THIRD_NODE;
    private static long FOURTH_NODE;
    private String desc;
    private Integer code;

    private PopupTimeAreaEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static PopupTimeAreaEnum getEnumByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        long originDate = calendar.getTimeInMillis();
        long dateTime = date.getTime();
        long subTime = dateTime - originDate;
        if (subTime > FOURTH_NODE) {
            return FOURTH;
        }
        if (subTime > THIRD_NODE) {
            return THIRD;
        }
        if (subTime > SECOND_NODE) {
            return SECOND;
        }
        if (subTime > FIRST_NODE) {
            return FIRST;
        }
        return FOURTH;
    }

    static {
        FIRST_NODE = 1800000L;
        SECOND_NODE = 23400000L;
        THIRD_NODE = 45000000L;
        FOURTH_NODE = 66600000L;
    }
}

