package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetActGroupDto;
import cn.com.duiba.activity.center.api.enums.AttributionTypeEnum;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/04/28
 */
@AdvancedFeignClient
public interface RemoteBackendBetActGroupService {
    /**
     * 新增投注活动组
     *
     * @param betActGroupDto 新增的参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(BetActGroupDto betActGroupDto) throws BizException;

    /**
     * 更新活动组名称
     *
     * @param id         key
     * @param groupTitle 活动组名称
     * @return 更新结果
     * @throws BizException bizException
     */
    Integer update(Long id, String groupTitle) throws BizException;

    /**
     * 删除投注活动组，活动对应的app，投注活动关系都会删除
     *
     * @param id key
     * @return 成功数
     */
    Integer delete(Long id);

    /**
     * 分页获取投注活动组列表
     * 为了兼容，默认attributionTypeEnum=DUIBA
     * @param pageNo   pageNo
     * @param pageSize pageSize
     * @return Page<BetActGroupDto>
     */
    Page<BetActGroupDto> list(Integer pageNo, Integer pageSize);

    /**
     * 分页获取投注活动组列表
     *
     * @param pageNo   pageNo
     * @param pageSize pageSize
     * @return Page<BetActGroupDto>
     */
    Page<BetActGroupDto> listByType(AttributionTypeEnum attributionTypeEnum, Integer pageNo, Integer pageSize);

    /**
     * 通过id获取投注活动组
     *
     * @param id key
     * @return BetActGroupDto
     */
    BetActGroupDto findById(Long id);
}
