package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetConfigDto;
import cn.com.duiba.activity.center.api.enums.AttributionTypeEnum;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/02
 */
@AdvancedFeignClient
public interface RemoteBackendBetConfigService {
    /**
     * 新增投注活动配置
     *
     * @param betConfigDto 投注活动配置参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(BetConfigDto betConfigDto) throws BizException;

    /**
     * 批量写入，上层校验合法性
     *
     * @param betConfigDto
     * @return
     * @throws BizException
     */
    List<BetConfigDto> batchInsert(List<BetConfigDto> betConfigDto);

    /**
     * 批量写入，并自动关联活动组
     * 1.pk赛组件使用
     * 2.返回组id
     *
     * @param betConfigDto
     * @return
     */
    Long batchInsertAndAssociateGroup(List<BetConfigDto> betConfigDto, Long appId,String title);

    /**
     * 更新投注活动,pk赛组件专用,只会更新部分字段
     *
     * @param betConfigDto 需要更新的投注活动配置
     * @return 是否成功
     * @throws BizException bizException
     */
    Integer updateByPkUnit(List<BetConfigDto> betConfigDto,Long appId);
    /**
     * 批量查询
     *
     * @param ids
     * @return
     */
    List<BetConfigDto> findByIds(List<Long> ids, Long appId);

    /**
     * 更新投注活动
     *
     * @param betConfigDto 需要更新的投注活动配置
     * @return 是否成功
     * @throws BizException bizException
     */
    Integer update(BetConfigDto betConfigDto) throws BizException;

    /**
     * 分页获取活动列表
     * 为了兼容，默认attributionTypeEnum=DUIBA
     *
     * @param pageNo   页码
     * @param pageSize 页面大小
     * @return Page<BetConfigDto>
     * @throws BizException bizException
     */
    Page<BetConfigDto> list(Integer pageNo, Integer pageSize) throws BizException;


    Page<BetConfigDto> listByType(AttributionTypeEnum attributionTypeEnum, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 返回结算时间小于当前时间的活动列表
     *
     * @return List<BetConfigDto>
     */
    List<BetConfigDto> listByEndTime();

    /**
     * 获取活动配置详情
     *
     * @param id key
     * @return betConfigDto
     * @throws BizException bizException
     */
    BetConfigDto findById(Long id) throws BizException;
}
