package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetConfigDto;
import cn.com.duiba.activity.center.api.enums.AttributionTypeEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/07
 */
@AdvancedFeignClient
public interface RemoteBetConfigService {
    /**
     * 通过id获取活动配置
     * @param id betId
     * @return 活动配置
     * @throws BizException bizException
     */
    BetConfigDto findById(Long id) throws BizException;

    /**
     * 根据状态、瓜分类型和结束时间范围查询活动列表
     * @param configStatus
     * @param bonusType
     * @param startTime
     * @param endTime
     * @return List<BetConfigDto>
     */
    List<BetConfigDto> getListByStatusAndEndTime(Integer configStatus, Integer bonusType, Date startTime, Date endTime);

    List<BetConfigDto> selectListByAppIdAndEndTime(Integer configStatus, Date endTime, AttributionTypeEnum attributionTypeEnum, Long appId);
}
