package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.activity.center.api.dto.BaseActivityDto;
import cn.com.duiba.api.enums.AppItemSourceTypeEnum;
import com.google.common.collect.ImmutableSet;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/6/13.
 */
public class OperatingActivityDto extends BaseActivityDto implements Serializable {

    // type int 删除移到common-service中的常量
    public static final int TypeDuibaActivity = 0; //专题活动
    public static final int TypeTurnTable = 1; // 大转盘活动
    public static final int TypeDuibaSingleLottery = 2; // 兑吧单品抽奖
    public static final int TypeAppSingleLottery = 3; // App自有单品抽奖
    public static final int TypeDuibaTurntable = 4; //兑吧大转盘
    public static final int TypeAppManualLottery = 5; //app自有手动开奖
    public static final int TypeShakeLottery = 6;//摇一摇
    public static final int TypeScratchCard = 7;//刮刮卡
    public static final int TypeHdToolTurntable = 8;//活动工具大转盘
    public static final int TypeHdToolTiger = 9;//老虎机
    public static final int TypeHdToolFlop = 11;//趣味翻牌
    public static final int TypeHdToolSmashg = 12;//砸彩蛋
    public static final int TypeSecondsKill = 30;//周三必抢

    public static final int TypeGameSanta = 20;//游戏活动-打劫圣诞老人
    public static final int TypeGameYearAward = 21;//游戏活动-数年终奖
    public static final int TypeGameGirl = 22;//游戏活动-女神pk
    public static final int TypeGameJiong = 23;//游戏活动-人在囧途
    public static final int TypeDuibaQuestionAnswer = 40;    // 兑吧答题    改属性  答题迁移后废弃    采用TypeActivityAccessQuestionAnswer
    public static final int TypeDuibaQuizz = 41;    // 测试题     改属性  测试题迁移后废弃    TypeActivityAccessQuizz
    public static final int TypeDuibaSeckill = 31;    // 兑吧秒杀活动
    public static final int TypeDuibaNgame = 28;    // 兑吧新游戏
    public static final int TypeDuibaGuess = 42;   // 兑吧竞猜
    public static final int TypeDuibaRob = 45;     // 今日必抢
    public static final int TypeDuibaCreditGame = 46;//积分游戏
    public static final int TypeDuibaLittleGame = 47;//小游戏
    public static final int TypePlugin = 50;//插件
    public static final int TypeDuibaElasticGifts = 49;//弹层活动
    public static final int TypeSign = 51;//签到
    public static final int LotteryActvity = 52; //博彩活动
    public static final int TypePK = 53; //pk赛
    public static final int TypeLotterySquare = 54; //红包广场
    public static final int TypeBrick = 56; //搬砖工活动
    // 与cn.com.duiba.api.enums.ActivityUniformityTypeEnum 中定义的类型保持一致
    public static final int TypeSeedRedPacket = 208;//种红包
    public static final int TypeLuckyCode = 31003;//幸运码活动

    public static final int TypeActivityAccessHdtool = 100;//迁移新活动工具的类型
    public static final int TypeActivityAccessQuestionAnswer = 101;//答题迁移后
    public static final String SubTypeTurntable_Circle = "turntable_circle";//新圆形大转盘

    //增加游戏的时候，请把新增的游戏类型加到下面的ImmutableSet《《《《《——————————注意
    public static final ImmutableSet<Integer> GAME_TYPES = ImmutableSet.of(TypeGameSanta, TypeGameYearAward, TypeGameGirl, TypeGameJiong, TypeDuibaNgame);

    //Start chaijiangang,幸运转盘改为活动工具,2016/04/12
    public static final String TypeShakeLottery_Action = "shake";//摇一摇
    public static final String TypeScratchCard_Action = "ScratchCard";//刮刮卡
    public static final String TypeHdToolTurntable_Action = "turntableNew";//活动工具大转盘
    public static final String TypeHdToolTiger_Action = "tiger";//老虎机
    public static final String TypeHdToolFlop_Action = "flop";//趣味翻牌
    public static final String TypeHdToolSmashg_Action = "smashg";//砸彩蛋
    public static final String TypeHdToolQuestion_Action = "question";//开发者 答题
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12

    //从此判断活动工具变得很容易！！
    public static final ImmutableSet<Integer> hdToolTypeSet = ImmutableSet.of(TypeShakeLottery, TypeScratchCard,
            TypeHdToolTurntable, TypeHdToolTiger, TypeHdToolFlop, TypeHdToolSmashg, TypeActivityAccessHdtool);
    
    public static final ImmutableSet<Integer> questionTypeSet = ImmutableSet.of(TypeDuibaQuestionAnswer, TypeActivityAccessQuestionAnswer);

    //从此判断活动工具变得很容易！！
    public static final ImmutableSet<Integer> appItemTypeSet = ImmutableSet.of(AppItemSourceTypeEnum.SourceTypeHdtoolTiger.getCode(),
            AppItemSourceTypeEnum.SourceTypeHdtoolFlop.getCode(), AppItemSourceTypeEnum.SourceTypeHdtoolSmashg.getCode(),
            AppItemSourceTypeEnum.SourceTypeHdtoolTurntable.getCode(), TypeActivityAccessHdtool);

    public static final int StatusIntNoComplete = 0; //数据不完整
    public static final int StatusIntComplete = 1; //数据完整
    public static final int StatusIntOpen = 2; //开启
    public static final int StatusIntClose = 3; //关闭

    //Start chaijiangang,幸运转盘改为活动工具,2016/04/12
    public static final int DoJoinStatusNoCredits = 2;//积分不足
    public static final int DoJoinStatusNoFreeEveryDay = 3;//今日没有抽奖次数
    public static final int DoJoinStatusNoFree = 4;//没有抽奖次数
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12

    public static final int SWITCHES_HDTOOLS_NEW = 1;//新活动工具
    public static final int ANTICHEAT_LIMIT_RULE = 5; // 开启直充类奖品防刷

    //支持子页面类型的活动放在这里，不放的话是不会展示的.
    public static final ImmutableSet<Integer> categoryActivitySet = ImmutableSet.of(TypeTurnTable, TypeShakeLottery,
            TypeScratchCard, TypeHdToolTurntable, TypeHdToolTiger, TypeHdToolFlop, TypeHdToolSmashg,
            TypeDuibaSingleLottery, TypeDuibaQuizz, TypeDuibaQuestionAnswer, TypeDuibaGuess, TypeDuibaNgame,
            TypeAppSingleLottery, TypeAppManualLottery, TypeActivityAccessHdtool, TypeDuibaSeckill, TypeDuibaLittleGame,
            TypeSecondsKill,TypeDuibaActivity,TypeActivityAccessQuestionAnswer,LotteryActvity);

    //不需要开发者入库就可以使用的活动
    public static final ImmutableSet<Integer> unNeedGroundingActivitySet = ImmutableSet.of(TypeDuibaLittleGame,
            TypePlugin,TypeSign);

    //开发者自有活动集合
    public static final ImmutableSet<Integer> appActivitySet = ImmutableSet.of(TypeAppManualLottery,TypeAppSingleLottery);

    private static final long serialVersionUID = -1137126468254229534L;
    private Long id;
    private Long appId; //appId
    private String title; //标题
    private Integer type; //活动类型
    private Integer status; //数据状态  引用：StatusInt*
    private Long appBannerId; //首页bannerID
    private Long appItemId; //兑换项ID
    private Long consumeCredits; // 消耗的总积分数
    private Integer consumeMoney;// 消耗的总金钱数
    private Integer winTimes; // 中奖人数
    private Long credits; // 消耗积分数
    private Integer limitCount; // 每日最多几次
    private Integer freeLimit; // 每日免费次数
    private String rule;// 活动规则
    private String explainText; // 活动说明
    private String image; // 主图
    private String smallImage;//缩略图
    private String logo;//小图标
    private String bannerImage;//banner
    private Long activityId; //引用活动ID,  如：兑吧专题活动，兑吧单品抽奖，兑吧大转盘.....
    private Integer activityOrderQuantity; //活动订单数
    private Integer failCount; // 领取失败数量， 数据库无此字段
    private Long parentActivityId;
    private Boolean deleted; // 是否已经删除
    private Date gmtCreate; //创建时间
    private Date gmtModified; //变更时间
    private Integer creditsType;//积分模式
    private String subType;//活动模版
    private String freeScope;//免费参数次数限制类型
    private String limitScope;//参与次数限制类型
    private String rateIntroduction;    // 概率说明
    private Long customCredits;    // 抽奖积分
    //Start guoeryang,直充类奖品防刷,2016/06/14
    private String exchangeLimit;//商品防刷
    //End guoeryang,直充类奖品防刷,2016/06/14
    private Integer switches;
    private Date autoOffDate; // 自动下架时间
    //是否对开发者隐藏
    private Boolean hiddenForDeveloper;

    /**
     * Creates a new instance of OperatingActivityDto.
     */
    public OperatingActivityDto() {
        super();
    }

    /**
     * Creates a new instance of OperatingActivityDto.
     *
     * @param type
     */
    public OperatingActivityDto(Integer type) {
        this.type = type;
    }
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12

    /**
     * Creates a new instance of OperatingActivityDto.
     *
     * @param init4insert
     */
    public OperatingActivityDto(boolean init4insert) {
        if (init4insert) {
            consumeCredits = 0L;
            consumeMoney = 0;
            winTimes = 0;
            credits = 0L;
            limitCount = 0;
            switches = 0;
            activityOrderQuantity = 0;
            deleted = false;
            gmtCreate = new Date();
            gmtModified = gmtCreate;

        }
    }

    /**
     * Creates a new instance of OperatingActivityDto.
     *
     * @param id
     */
    public OperatingActivityDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public String getExchangeLimit() {
        return exchangeLimit;
    }

    public void setExchangeLimit(String exchangeLimit) {
        this.exchangeLimit = exchangeLimit;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getAppBannerId() {
        return appBannerId;
    }

    public void setAppBannerId(Long appBannerId) {
        this.appBannerId = appBannerId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getConsumeCredits() {
        return consumeCredits;
    }

    public void setConsumeCredits(Long consumeCredits) {
        this.consumeCredits = consumeCredits;
    }

    public Integer getConsumeMoney() {
        return consumeMoney;
    }

    public void setConsumeMoney(Integer consumeMoney) {
        this.consumeMoney = consumeMoney;
    }

    public Integer getWinTimes() {
        return winTimes;
    }

    public void setWinTimes(Integer winTimes) {
        this.winTimes = winTimes;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public Integer getFreeLimit() {
        return freeLimit;
    }

    public void setFreeLimit(Integer freeLimit) {
        this.freeLimit = freeLimit;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getExplainText() {
        return explainText;
    }

    public void setExplainText(String explainText) {
        this.explainText = explainText;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityOrderQuantity() {
        return activityOrderQuantity;
    }

    public void setActivityOrderQuantity(Integer activityOrderQuantity) {
        this.activityOrderQuantity = activityOrderQuantity;
    }

    public Integer getFailCount() {
        return failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public Long getParentActivityId() {
        return parentActivityId;
    }

    public void setParentActivityId(Long parentActivityId) {
        this.parentActivityId = parentActivityId;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getCreditsType() {
        return creditsType;
    }

    public void setCreditsType(Integer creditsType) {
        this.creditsType = creditsType;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getFreeScope() {
        return freeScope;
    }

    public void setFreeScope(String freeScope) {
        this.freeScope = freeScope;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public String getRateIntroduction() {
        return rateIntroduction;
    }

    public void setRateIntroduction(String rateIntroduction) {
        this.rateIntroduction = rateIntroduction;
    }

    public Long getCustomCredits() {
        return customCredits;
    }

    public void setCustomCredits(Long customCredits) {
        this.customCredits = customCredits;
    }

    // 改造成整数，不依赖duiba-service
    public int getAppItemSourceType() {
        switch (this.type) {
            case TypeDuibaActivity: // 专题活动 ok
                return 2;
            case TypeDuibaSingleLottery: // 兑吧单品抽奖 ok
            case TypeAppSingleLottery: // App自有单品抽奖 ok
                return 3;
            case TypeAppManualLottery: // app自有手动开奖 ok
                return 4;
            case TypeTurnTable: // 大转盘活动
            case TypeDuibaTurntable: // 兑吧大转盘 ok
            case TypeShakeLottery: // 摇一摇 ok
            case TypeScratchCard: // 刮刮卡 ok
            case TypeHdToolTurntable: // 活动工具大转盘 ok
            case TypeHdToolTiger: // 老虎机 ok
            case TypeHdToolFlop: // 趣味翻牌 ok
            case TypeHdToolSmashg: // 砸彩蛋 ok
                return 1;
            case TypeSecondsKill: // 秒杀专题
                return 11;
            case TypeGameSanta: // 圣诞游戏
                return 20;
            case TypeGameYearAward: // 数年终奖游戏
                return 21;
            case TypeGameGirl: // 女神游戏
                return 22;
            case TypeGameJiong: // 人在囧途
                return 23;
            case TypeDuibaQuestionAnswer: // 兑吧答题活动
                return 30;
            case TypeDuibaQuizz://测试题活动
                return 41;
            case TypeDuibaNgame://新游戏
                return 28;
            case TypeDuibaGuess://竞猜
                return 42;
            case TypeDuibaCreditGame:
                return 46;
            default:
                return 0;
        }
    }

    // 改造成整数，不依赖duiba-service
    public int getAppBannerSourceType() {
        switch (this.type) {
            case TypeDuibaActivity: // 专题活动 ok
                return 2;
            case TypeDuibaSingleLottery: // 兑吧单品抽奖 ok
            case TypeAppSingleLottery: // App自有单品抽奖 ok
                return 4;
            case TypeAppManualLottery: // app自有手动开奖 ok
                return 5;
            case TypeTurnTable: // 大转盘活动
            case TypeDuibaTurntable: // 兑吧大转盘 ok
            case TypeShakeLottery: // 摇一摇 ok
            case TypeScratchCard: // 刮刮卡 ok
            case TypeHdToolTurntable: // 活动工具大转盘 ok
            case TypeHdToolTiger: // 老虎机 ok
            case TypeHdToolFlop: // 趣味翻牌 ok
            case TypeHdToolSmashg: // 砸彩蛋 ok
                return 1;
            case TypeSecondsKill: // 秒杀专题
                return 11;
            case TypeGameSanta: // 圣诞游戏
                return 20;
            case TypeGameYearAward: // 数年终奖游戏
                return 21;
            case TypeGameGirl: // 女神游戏
                return 22;
            case TypeGameJiong: //
                return 23;
            case TypeDuibaQuestionAnswer: // 兑吧答题游戏
                return 30;
            case TypeDuibaQuizz://测试题活动
                return 41;
            case TypeDuibaNgame://新游戏
                return 28;
            case TypeDuibaGuess://竞猜
                return 42;
            case TypeDuibaCreditGame://积分游戏
                return 46;
            default:
                return 0;
        }
    }

    /**
     * Start chaijiangang,幸运转盘改为活动工具,2016/04/12
     * getPreviewAction:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @since JDK 1.6
     */
    public String getPreviewAction() {
        switch (this.type) {
            case TypeShakeLottery: // 摇一摇 ok
                return TypeShakeLottery_Action;
            case TypeScratchCard: // 刮刮卡 ok
                return TypeScratchCard_Action;
            case TypeHdToolTurntable: // 活动工具大转盘 ok
                return TypeHdToolTurntable_Action;
            case TypeHdToolTiger: // 老虎机 ok
                return TypeHdToolTiger_Action;
            case TypeHdToolFlop: // 趣味翻牌 ok
                return TypeHdToolFlop_Action;
            case TypeHdToolSmashg: // 砸彩蛋 ok
                return TypeHdToolSmashg_Action;
            case TypeDuibaQuestionAnswer:
                return TypeHdToolQuestion_Action;
            default:
                return "";
        }
    }

    /**
     * 判断是否是游戏活动
     *
     * @return
     */
    public boolean isGame() {
        Boolean flag = false;
        if (this.type == TypeGameSanta
                || this.type == TypeGameYearAward
                || this.type == TypeGameGirl
                || this.type == TypeGameJiong) {
            flag = true;
        }
        return flag;
    }

    /**
     * 判断是否是活动工具
     *
     * @return
     */
    public boolean isHdTool() {
        switch (this.type) {
            case TypeShakeLottery:
            case TypeScratchCard:
            case TypeHdToolTiger:
            case TypeHdToolTurntable:
            case TypeHdToolFlop:
            case TypeHdToolSmashg:
                return true;
            default:return false;
        }
    }

    /**
     * isHdTool:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param type
     * @return
     * @since JDK 1.6
     */
    public static boolean isHdTool(Integer type) {
        switch (type) {
            case TypeShakeLottery:
            case TypeScratchCard:
            case TypeHdToolTiger:
            case TypeHdToolTurntable:
            case TypeHdToolFlop:
            case TypeHdToolSmashg:
                return true;
            default:return false;
        }
    }
    //Start chaijiangang,不参与抽奖积分可编辑活动,2016/04/12

    /**
     * isCjTool:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param types
     * @return
     * @since JDK 1.6
     */
    public static boolean isCjTool(Integer types) {
        Boolean flag = true;
        // 周三必抢 专题活动 兑吧秒杀活动
        if (types == TypeSecondsKill || types == TypeDuibaActivity || types == TypeDuibaSeckill) {
            flag = false;
        }
        return flag;
    }
    //End chaijiangang,不参与抽奖积分可编辑活动,2016/04/12

    public Integer getSwitches() {
        return switches;
    }


    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    /**
     * grantOpSwitches:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param opType
     * @since JDK 1.6
     */
    public void grantOpSwitches(int opType) {
        int v = 1 << opType;
        switches = switches | v;
    }

    /**
     * ungrantOpSwitches:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param opType
     * @since JDK 1.6
     */
    public void ungrantOpSwitches(int opType) {
        int v = 1 << opType;
        v = ~v;
        switches = switches & v;
    }

    /**
     * isOpSwitches:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param opType
     * @return
     * @since JDK 1.6
     */
    public boolean isOpSwitches(int opType) {
        int v = 1 << opType;
        int ret = switches & v;
        return ret != 0;
    }

    /**
     * 我觉得对于dto不应该提供此静态方法,type本来就是OperatingActivityDto内部的字段
     * 不应该通过参数再传一个进来
     * 其次这里并没有对活动工具的类型做兼容处理,可以考虑将此方法删除
     * getTypeNameByType:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param type
     * @deprecated getTypeNameByType
     * @return
     * @since JDK 1.6
     */
    @Deprecated
    public static String getTypeNameByType(Integer type) {
        switch (type) {
            case TypeDuibaActivity: // 专题活动 ok
                return "专题活动";
            case TypeShakeLottery: // 摇一摇 ok
                return "摇一摇";
            case TypeScratchCard: // 刮刮卡 ok
                return "刮刮乐";
            case TypeHdToolTurntable: // 活动工具大转盘 ok
                return "大转盘";
            case TypeHdToolTiger: // 老虎机 ok
                return "摇奖机";
            case TypeHdToolFlop: // 趣味翻牌 ok
                return "趣味翻牌";
            case TypeHdToolSmashg: // 砸彩蛋 ok
                return "砸彩蛋";
            case TypeSecondsKill: // 秒杀专题
                return "秒杀专题";
            case TypeGameSanta: // 圣诞游戏
                return "圣诞游戏";
            case TypeGameYearAward: // 数年终奖游戏
                return "数年终奖游戏";
            case TypeGameGirl: // 女神游戏
                return "女神游戏";
            case TypeGameJiong: // 人在囧途
                return "人在囧途";
            case TypeDuibaQuestionAnswer: // 兑吧答题活动
                return "答题";
            case TypeDuibaQuizz://测试题活动
                return "测试题";
            case TypeDuibaNgame://新游戏
                return "新游戏";
            case TypeDuibaGuess://竞猜
                return "竞猜";
            case TypeDuibaRob:
                return "今日必抢";
            case TypeDuibaCreditGame:
                return "积分游戏";
            case TypeDuibaLittleGame:
                return "小游戏";
            default:
                return "不知道啥活动,请在OperatingActivityDto.getTypeNameByType()定义";
        }
    }

    public Boolean getHiddenForDeveloper() {
        return hiddenForDeveloper;
    }

    public void setHiddenForDeveloper(Boolean hiddenForDeveloper) {
        this.hiddenForDeveloper = hiddenForDeveloper;
    }
}
