package cn.com.duiba.activity.center.api.remoteservice.lottery;

import cn.com.duiba.activity.center.api.dto.lottery.LotteryBetDto;
import cn.com.duiba.activity.center.api.dto.lottery.LotteryBetOddsDto;
import cn.com.duiba.activity.center.api.dto.lottery.LotteryBetRecordDto;
import cn.com.duiba.activity.center.api.dto.lottery.LotteryBetRecordOptionsDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/06/01
 */
@AdvancedFeignClient
public interface RemoteLotteryBetService {
    /**
     * 通过id获取活动配置
     * @see LotteryBetDto
     * @param id id
     * @return LotteryBetDto
     */
    LotteryBetDto findById(Long id);

    /**
     * 通过活动组id分页获取当前可以押注的活动
     * @param appId appId
     * @param groupId 活动组id
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @return Page<LotteryBetDto>
     */
    Page<LotteryBetDto> listCurrentByGroupIdApi(Long appId, Long groupId, Integer pageNo, Integer pageSize);

    /**
     * 通过活动组id分页获取往期的历史活动
     * @param groupId 活动组id
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @return Page<LotteryBetDto>
     */
    Page<LotteryBetDto> listHistoryByGroupIdApi(Long groupId, Integer pageNo, Integer pageSize);

    /**
     * 分页获取用户博彩历史
     * @param consumerId 用户id
     * @param groupId groupId
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @return Page<LotteryBetRecordOptionsDto>
     */
    Page<LotteryBetRecordOptionsDto> listRecordByConsumerIdApi(Long consumerId, Long groupId, Integer pageNo, Integer pageSize);

    /**
     * 获取该app下指定博彩活动的选项赔率
     * @param appId appId
     * @param consumerId consumerId
     * @param lotteryBetId 博彩活动id
     * @return List<LotteryBetOddsDto>
     */
    List<LotteryBetOddsDto> listOptionOdds(Long appId, Long consumerId, Long lotteryBetId);

    /**
     * 设置领奖状态
     * @param consumerId 用户id
     * @param orderNum 订单id
     * @return 是否成功
     */
    Boolean doDraw(Long consumerId, String orderNum);

    /**
     * 获取订单详情
     * @param orderNum 订单id
     * @return LotteryBetRecordDto
     */
    LotteryBetRecordDto findByOrderNum(String orderNum);

}
