package cn.com.duiba.activity.center.api.dto.creditsfarm;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author chenxiangge
 * @Date 2019/8/5
 */
public class CreditsFarmActSaveParam implements Serializable {

    private static final long serialVersionUID = -6873964730360157393L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动投放应用类型（ 0-app;1-公众号;2-小程序）用逗号隔开
     */
    private String appType;

    /**
     * 活动玩法 （0-成本可控型）
     */
    private Integer playType;

    /**
     * 活动规则
     */
    private String rule;

    /**
     * 兑换奖品需要的果实（mg）
     */
    private Integer prizeCost;

    /**
     * 每日种植次数上限
     */
    private Integer dayCropLimit;
    /**
     * 每日营养液数量上限
     */
    private Integer nutritionCountLimit;

    /**
     * 积分回收率（%）
     */
    private Integer takeBackRatio;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 小程序授权地址
     */
    private String authorizeUrl;

    /**
     * 公众号二维码
     */
    private String wechatQrCode;

    /**
     * 活动缩略图 - 入库活动用
     */
    private String smallImage;

    private List<CreditsFarmSeedDto> seeds;

    private List<CreditsFarmTaskDto> tasks;

    private List<CreditsFarmOptionDto> options;

    public List<CreditsFarmSeedDto> getSeeds() {
        return seeds;
    }

    public void setSeeds(List<CreditsFarmSeedDto> seeds) {
        this.seeds = seeds;
    }

    public List<CreditsFarmTaskDto> getTasks() {
        return tasks;
    }

    public void setTasks(List<CreditsFarmTaskDto> tasks) {
        this.tasks = tasks;
    }

    public List<CreditsFarmOptionDto> getOptions() {
        return options;
    }

    public void setOptions(List<CreditsFarmOptionDto> options) {
        this.options = options;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAppType() {
        return appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public Integer getPlayType() {
        return playType;
    }

    public void setPlayType(Integer playType) {
        this.playType = playType;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Integer getPrizeCost() {
        return prizeCost;
    }

    public void setPrizeCost(Integer prizeCost) {
        this.prizeCost = prizeCost;
    }

    public Integer getDayCropLimit() {
        return dayCropLimit;
    }

    public void setDayCropLimit(Integer dayCropLimit) {
        this.dayCropLimit = dayCropLimit;
    }

    public Integer getTakeBackRatio() {
        return takeBackRatio;
    }

    public void setTakeBackRatio(Integer takeBackRatio) {
        this.takeBackRatio = takeBackRatio;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getAuthorizeUrl() {
        return authorizeUrl;
    }

    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public String getWechatQrCode() {
        return wechatQrCode;
    }

    public void setWechatQrCode(String wechatQrCode) {
        this.wechatQrCode = wechatQrCode;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public Integer getNutritionCountLimit() {
        return nutritionCountLimit;
    }

    public void setNutritionCountLimit(Integer nutritionCountLimit) {
        this.nutritionCountLimit = nutritionCountLimit;
    }
}
