package cn.com.duiba.activity.center.api.dto.seedredpacket;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/7/5
 * @description 种红包
 */
public class SeedRedPacketDto implements Serializable {

	private static final long serialVersionUID = -3258354801603374791L;

	/** 关闭 */
	public static final int STATUS_CLOSE = 0;
	/** 开启 */
	public static final int STATUS_OPEN = 1;

	/**
	 * 活动id
	 */
	private Long id;

	/**
	 * 标题
	 */
	private String title;

	/**
	 * 种红包所需积分价值
	 */
	private Long seedCreditsPrice;

	/**
	 * 解锁4号土地所需积分价值
	 */
	private Long unlockLandCreditsPrice;

	/**
	 * 是否开启：0，关闭；1，开启
	 */
	private Integer status;

	/**
	 * 创建时间
	 */
	private Date gmtCreate;

	/**
	 * 红包成长时间列表
	 */
	private List<SeedRedPacketGrownTimeDto> grownTimeList;

	/**
	 * 活动规则
	 */
	private String rule;

	/**
	 * 广告开关
	 */
	private Boolean adSwitch;

	/**
	 * 广告位置
	 */
	private String adPositions;

	/**
	 * 红包衰减开关
	 */
	private Boolean decrSwitch;

	/**
	 * 红包开始衰减时间
	 */
	private Long decrBeginTime;

	/**
	 * 广告投放appId列表
	 */
	private String appIds4Adver;

	/**
	 * 每日种植个数
	 */
	private Long plantNumDaily;

	/**
	 * 每日中奖个数
	 */
	private Long drawNumDaily;

	/**
	 * 偷红包开关
	 */
	private Boolean stealRedPacketSwitch;

	/**
	 * 月预算
	 */
	private Long monthBudget;

	/** 账号类型 0:积分商城红包账户 */
	private Integer accountType;
	/** 周期id */
	private Long periodId;
	/** 可提现人数 */
	private Integer bonusNumber;
	/** 可提现用户获奖上线 */
	private Integer bonusLimit;
	/** 不可提现用户获奖上线 */
	private Integer unBonusLimit;
	/** appId */
	private Long appId;
	/** 活动开始时间 */
	private Date startTime;
	/** 活动结束时间 */
	private Date endTime;
	/** 入库活动id */
	private Long operatingActivityId;
	/** 界面配置信息 */
	private String dataJson;
	/** 组件id */
	private Long unitId;
	/** 奖励类型 1:人民币 2:虚拟货币 */
	private Integer rewardType;
	/**
	 * 广告位配置
	 */
	private String adConfig;

	public Integer getRewardType() {
		return rewardType;
	}

	public void setRewardType(Integer rewardType) {
		this.rewardType = rewardType;
	}

	public Long getUnitId() {
		return unitId;
	}

	public void setUnitId(Long unitId) {
		this.unitId = unitId;
	}

	public String getDataJson() {
		return dataJson;
	}

	public void setDataJson(String dataJson) {
		this.dataJson = dataJson;
	}

	public Long getOperatingActivityId() {
		return operatingActivityId;
	}

	public void setOperatingActivityId(Long operatingActivityId) {
		this.operatingActivityId = operatingActivityId;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Integer getAccountType() {
		return accountType;
	}

	public void setAccountType(Integer accountType) {
		this.accountType = accountType;
	}

	public Long getPeriodId() {
		return periodId;
	}

	public void setPeriodId(Long periodId) {
		this.periodId = periodId;
	}

	public Integer getBonusNumber() {
		return bonusNumber;
	}

	public void setBonusNumber(Integer bonusNumber) {
		this.bonusNumber = bonusNumber;
	}

	public Integer getBonusLimit() {
		return bonusLimit;
	}

	public void setBonusLimit(Integer bonusLimit) {
		this.bonusLimit = bonusLimit;
	}

	public Integer getUnBonusLimit() {
		return unBonusLimit;
	}

	public void setUnBonusLimit(Integer unBonusLimit) {
		this.unBonusLimit = unBonusLimit;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Long getSeedCreditsPrice() {
		return seedCreditsPrice;
	}

	public void setSeedCreditsPrice(Long seedCreditsPrice) {
		this.seedCreditsPrice = seedCreditsPrice;
	}

	public Long getUnlockLandCreditsPrice() {
		return unlockLandCreditsPrice;
	}

	public void setUnlockLandCreditsPrice(Long unlockLandCreditsPrice) {
		this.unlockLandCreditsPrice = unlockLandCreditsPrice;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public List<SeedRedPacketGrownTimeDto> getGrownTimeList() {
		return grownTimeList;
	}

	public void setGrownTimeList(List<SeedRedPacketGrownTimeDto> grownTimeList) {
		this.grownTimeList = grownTimeList;
	}

	public Boolean getAdSwitch() {
		return adSwitch;
	}

	public void setAdSwitch(Boolean adSwitch) {
		this.adSwitch = adSwitch;
	}

	public String getAdPositions() {
		return adPositions;
	}

	public void setAdPositions(String adPositions) {
		this.adPositions = adPositions;
	}

	public String getRule() {
		return rule;
	}

	public Boolean getDecrSwitch() {
		return decrSwitch;
	}

	public void setDecrSwitch(Boolean decrSwitch) {
		this.decrSwitch = decrSwitch;
	}

	public Long getDecrBeginTime() {
		return decrBeginTime;
	}

	public void setDecrBeginTime(Long decrBeginTime) {
		this.decrBeginTime = decrBeginTime;
	}

	public void setRule(String rule) {
		this.rule = rule;
	}

	public String getAppIds4Adver() {
		return appIds4Adver;
	}

	public void setAppIds4Adver(String appIds4Adver) {
		this.appIds4Adver = appIds4Adver;
	}

	public Long getPlantNumDaily() {
		return plantNumDaily;
	}

	public void setPlantNumDaily(Long plantNumDaily) {
		this.plantNumDaily = plantNumDaily;
	}

	public Long getDrawNumDaily() {
		return drawNumDaily;
	}

	public void setDrawNumDaily(Long drawNumDaily) {
		this.drawNumDaily = drawNumDaily;
	}

	public Boolean getStealRedPacketSwitch() {
		return stealRedPacketSwitch;
	}

	public void setStealRedPacketSwitch(Boolean stealRedPacketSwitch) {
		this.stealRedPacketSwitch = stealRedPacketSwitch;
	}

	public Long getMonthBudget() {
		return monthBudget;
	}

	public void setMonthBudget(Long monthBudget) {
		this.monthBudget = monthBudget;
	}

	// 根据红包序号获取红包成熟所需时间
	public Long getGrownTime(Integer redPacketNumber){
		for(SeedRedPacketGrownTimeDto grownTime: grownTimeList){
			if(grownTime.getRedPacketId().equals(redPacketNumber)){
				return grownTime.getGrownTime();
			}
		}
		return null;
	}

	public String getAdConfig() {
		return adConfig;
	}

	public void setAdConfig(String adConfig) {
		this.adConfig = adConfig;
	}
}
