package cn.com.duiba.activity.center.api.remoteservice.creditgame;

import cn.com.duiba.activity.center.api.dto.creditgame.AddCreditFlowRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 加积分流水记录暴露服务
 * @author jyc
 * @since 2016-10-17
 */
@AdvancedFeignClient
public interface RemoteAddCreditFlowRecordService {
    /**
     * 增加加积分流水记录
     * @param addCreditFlowRecordDto
     * @return
     */
    DubboResult<Boolean> insert(AddCreditFlowRecordDto addCreditFlowRecordDto);

    /**
     * 根据订单ID更新流水记录
     * @param addCreditFlowRecordDto 加积分流水记录(必须包含orderId属性)
     * @return
     */
    DubboResult<Boolean> updateByOrderId(AddCreditFlowRecordDto addCreditFlowRecordDto);

    /**
     * 根据订单ID查询加积分流水记录
     * @param orderId
     * @return
     */
    DubboResult<AddCreditFlowRecordDto> getByOrderId(Long orderId);
}
