package cn.com.duiba.activity.center.api.remoteservice.label.param;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description: TODO  $
 */
public class LabelPassGoodsFilterParamBuilder {

    private List<Long> appItemIds;

    private String strategyType;

    private Long appId;

    private Long cid;

    private String userId;


    public LabelPassGoodsFilterParamBuilder setAppItemIds(List<Long> appItemIds) {
        this.appItemIds = appItemIds;
        return this;
    }

    public LabelPassGoodsFilterParamBuilder setAppItemIds(Long... appItemIds) {
        if (appItemIds == null || appItemIds.length == 0) {
            return this;
        }
        if (this.appItemIds == null) {
            this.appItemIds = new ArrayList<>();
        }
        for (Long appItemId : appItemIds) {
            if (appItemId != null) {
                this.appItemIds.add(appItemId);
            }
        }
        return this;
    }

    public LabelPassGoodsFilterParamBuilder setStrategyType(String strategyType) {
        this.strategyType = strategyType;
        return this;
    }

    public LabelPassGoodsFilterParamBuilder setAppId(Long appId) {
        this.appId = appId;
        return this;

    }

    public LabelPassGoodsFilterParamBuilder setCid(Long cid) {
        this.cid = cid;
        return this;

    }

    public LabelPassGoodsFilterParamBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public LabelPassGoodsFilterParam builder(){
        if (StringUtils.isBlank(strategyType)){
            throw new IllegalArgumentException("strategyType not blank");
        }
        if(appId == null){
            throw new IllegalArgumentException("appId not null");
        }
        if (CollectionUtils.isEmpty(appItemIds)){
            throw new IllegalArgumentException("appItemIds not empty");
        }
        if (StringUtils.isBlank(userId)){
            throw new IllegalArgumentException("userId not blank");
        }
        LabelPassGoodsFilterParam param = new LabelPassGoodsFilterParam();
        param.setAppItemIds(appItemIds);
        param.setAppId(appId);
        param.setStrategyType(strategyType);
        param.setUserId(userId);
        param.setCid(cid);
        return param;
    }
}
