package cn.com.duiba.activity.center.api.remoteservice.qqwallet;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.qqwallet.QqWalletDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


/**
 * Created by xiaoxuda on 2016/11/17. 
 * 商品地域限制服务
 */
@AdvancedFeignClient
public interface RemoteQqWalletService {

	/**
	 * 查询订单信息
	 * @param paramMap
	 * @return
	 */
	public List<QqWalletDto> findByMap(Map<String, Object> paramMap);
	
	/**
	 * 
	 * countByMap:(这里用一句话描述这个方法的作用). <br/>
	 * 统计订单条数
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByMap(Map<String, Object> queryMap);
	
	/**
	 * 根据订单id  查询订单信息
	 * @param orderNum
	 * @return
	 */
	public QqWalletDto findByOrderNum(String orderNum);

	/**
	 * 生成订单记录
	 * @param dto
	 * @return 添加条数
	 */
	public Integer insertQqWallet(QqWalletDto dto);

	/**
	 * 更新订单信息
	 * @param dto
	 * @return 更新条数
	 */
	public Integer updateQqWallet(QqWalletDto dto);
	
	
}
