package cn.com.duiba.activity.center.api.dto.freegroup;

import java.io.Serializable;

/**
 * @author: zhengjianhao
 * @date: 2019/3/19 15:57
 * @description: 0元拼团工具-投放渠道配置
 */
public class FreeGroupChannelDto implements Serializable {

	private static final long serialVersionUID = 610864570354812604L;
	/**
	 * 拼团渠道id
	 */
	private Long id;

	/**
	 * 拼团活动id
	 */
	private Long configId;

	/**
	 * 渠道类型：1，app；2，公众号
	 * @see cn.com.duiba.activity.center.api.enums.FreeGroupChannelTypeEnum
	 */
	private Integer channelType;

	/**
	 * 开启状态：0，关闭；1，开启
	 */
	private Integer openStatus;

	/**
	 * 参与条件类型：1，注册/登录才可参与
	 * @see cn.com.duiba.activity.center.api.enums.FreeGroupChannelConditionEnum
	 */
	private Integer participateConditionType;

	/**
	 * 登录方式类型：1，进入活动页前登录；2，进入页面任意点击行为触发登录
	 * @see cn.com.duiba.activity.center.api.enums.FreeGroupChannelLogOnTypeEnum
	 */
	private Integer logOnType;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getConfigId() {
		return configId;
	}

	public void setConfigId(Long configId) {
		this.configId = configId;
	}

	public Integer getChannelType() {
		return channelType;
	}

	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}

	public Integer getOpenStatus() {
		return openStatus;
	}

	public void setOpenStatus(Integer openStatus) {
		this.openStatus = openStatus;
	}

	public Integer getParticipateConditionType() {
		return participateConditionType;
	}

	public void setParticipateConditionType(Integer participateConditionType) {
		this.participateConditionType = participateConditionType;
	}

	public Integer getLogOnType() {
		return logOnType;
	}

	public void setLogOnType(Integer logOnType) {
		this.logOnType = logOnType;
	}
}
