package cn.com.duiba.activity.center.api.dto.lotterysquare;

import cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool.PerAmountLimitTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 红包广场 - 提现配置
 * @Author chenxiangge
 * @Date 2018/12/28
 */
public class LotterySquareWithdrawConfigDto implements Serializable {
    /**
     * 钱包清零时间
     */
    private Date clearTimeDate;

    /**
     * 单个用户提现额度限制：1-固定额度，10-无限制
     */
    private PerAmountLimitTypeEnum perAmountLimitType;
    /**
     * 限制额度（单位：分）
     */
    private Long perLimitAmount;

    /**
     * 提现次数限制
     */
    private Integer drawTimeLimit;

    public Date getClearTimeDate() {
        return clearTimeDate;
    }

    public void setClearTimeDate(Date clearTimeDate) {
        this.clearTimeDate = clearTimeDate;
    }

    public PerAmountLimitTypeEnum getPerAmountLimitType() {
        return perAmountLimitType;
    }

    public void setPerAmountLimitType(PerAmountLimitTypeEnum perAmountLimitType) {
        this.perAmountLimitType = perAmountLimitType;
    }

    public Long getPerLimitAmount() {
        return perLimitAmount;
    }

    public void setPerLimitAmount(Long perLimitAmount) {
        this.perLimitAmount = perLimitAmount;
    }

    public Integer getDrawTimeLimit() {
        return drawTimeLimit;
    }

    public void setDrawTimeLimit(Integer drawTimeLimit) {
        this.drawTimeLimit = drawTimeLimit;
    }
}
