package cn.com.duiba.activity.center.api.dto.ngame;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 
 * ClassName: NgameOptionDto <br/>
 * date: 2016年12月1日 上午10:08:06 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public class NgameOptionDto implements Serializable{

    private static final long serialVersionUID = 1L;
    private Long id;
	private Long gameConfigDuibaId;
	private Long itemId;
	private Long appItemId;
	private String name;
	private Integer payload;
	private String prizeType;
	private String facePrice;
	private Integer limitCount;
	private Integer hidden;
	private String logo;
	private String description;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;
	private String scope;
	private Integer scopeStart;
	private Integer scopeEnd;
	private Boolean autoOpen;
	private Integer remaining;

	private List<ConsumerRankDto> consumerRankVOs;

	/**
	 * 
	 * Creates a new instance of NgameOptionDto.
	 *
	 */
	public NgameOptionDto() {
	    super();
	}

	/**
	 * 
	 * Creates a new instance of NgameOptionDto.
	 *
	 * @param gameOptionDuiba
	 */
	public NgameOptionDto(DuibaNgameOptionsDto gameOptionDuiba) {
		this.id = gameOptionDuiba.getId();
		this.gameConfigDuibaId = gameOptionDuiba.getDuibaGameId();
		this.itemId = gameOptionDuiba.getItemId();
		this.name = gameOptionDuiba.getPrizeName();
		this.payload = gameOptionDuiba.getPayload();
		this.prizeType = gameOptionDuiba.getPrizeType();
		this.facePrice = gameOptionDuiba.getFacePrice();
		this.hidden = gameOptionDuiba.getHidden() ? 1 : 0;
		this.logo = gameOptionDuiba.getLogo();
		this.description = gameOptionDuiba.getDescription();
		this.deleted = gameOptionDuiba.getDeleted();
		this.gmtCreate = gameOptionDuiba.getGmtCreate();
		this.gmtModified = gameOptionDuiba.getGmtModified();
		this.autoOpen = gameOptionDuiba.getAutoOpen();
		this.remaining = gameOptionDuiba.getRemaining();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getGameConfigDuibaId() {
		return gameConfigDuibaId;
	}

	public void setGameConfigDuibaId(Long gameConfigDuibaId) {
		this.gameConfigDuibaId = gameConfigDuibaId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}

	public String getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(String facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public Integer getHidden() {
		return hidden;
	}

	public void setHidden(Integer hidden) {
		this.hidden = hidden;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public Integer getScopeEnd() {
		return scopeEnd;
	}

	public void setScopeEnd(Integer scopeEnd) {
		this.scopeEnd = scopeEnd;
	}

	public Integer getScopeStart() {
		return scopeStart;
	}

	public void setScopeStart(Integer scopeStart) {
		this.scopeStart = scopeStart;
	}

	public List<ConsumerRankDto> getConsumerRankVOs() {
		return consumerRankVOs;
	}

	public void setConsumerRankVOs(List<ConsumerRankDto> consumerRankVOs) {
		this.consumerRankVOs = consumerRankVOs;
	}

	public Boolean getAutoOpen() {
		return autoOpen;
	}

	public void setAutoOpen(Boolean autoOpen) {
		this.autoOpen = autoOpen;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

}
