/**
 * Project Name:activity-center-api File Name:TodayRobSeckillAppDto.java Package
 * Name:cn.com.duiba.activity.center.api.dto.rob Date:2016年10月9日下午2:12:26 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.activity.center.api.dto.rob;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

/**
 * 手机端秒杀区间DTO Date: 2016年10月9日 下午2:12:26 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class TodayRobSeckillAppDto extends BaseDto {

    /**
     */
    private static final long          serialVersionUID = 7996580245100241438L;

    /** 秒杀区间主键 */
    private Long                       id;

    /** 秒杀区间开始时间 */
    private Date                       startTime;

    /** 秒杀区间是否开启 */
    private boolean                    enable;

    /** 是否删除 */
    private boolean                    deleted;

    /** 是否所有活动已结束 */
    private boolean                    activityEnd;

    /** 开发者库中对应秒杀区间中的活动列表 */
    private List<OperatingActivityDto> operatingActivityList;

    /**秒杀类型,secondSubject：秒杀专题，secondActivity：秒杀专题 */
    private String secondType;

    /**秒杀图片 */
    private String image;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isActivityEnd() {
        return activityEnd;
    }

    public void setActivityEnd(boolean activityEnd) {
        this.activityEnd = activityEnd;
    }

    public List<OperatingActivityDto> getOperatingActivityList() {
        return operatingActivityList;
    }

    public void setOperatingActivityList(List<OperatingActivityDto> operatingActivityList) {
        this.operatingActivityList = operatingActivityList;
    }

    public String getSecondType() {
        return secondType;
    }

    public void setSecondType(String secondType) {
        this.secondType = secondType;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }
}
