package cn.com.duiba.activity.center.api.dto.underseagame;

import java.io.Serializable;
import java.util.Date;

/**
 * 海底游戏机奖品配置
 * @Author: xuwei
 * @Date: 2020/07/16
 */
public class UnderseaGamePrizeConfigDto implements Serializable {

    private static final long serialVersionUID = -7123359642399537199L;

    /**
     * 奖品类型-谢谢参与
     */
    public static final String TYPE_THANKS = "thanks";

    /**
     * 主键
     */
    private Long id;

    /**
     * 海底游戏机配置ID
     */
    private Long configId;

    /**
     * 关卡 (1, 2, 3)，如果是所有关卡完成后抽奖，则为0
     */
    private Integer roundIndex;

    /**
     * 关联商品ID
     */
    private Long appItemId;

    /**
     * 奖品类型
     */
    private String prizeType;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeImage;

    /**
     * 奖品信息
     */
    private String prizeDesc;

    /**
     * 面额
     */
    private String facePrice;

    /**
     * 剩余奖品数
     */
    private Integer remainingStock;

    /**
     * 中奖概率（百万分比)
     */
    private Integer rate;

    /**
     * 是否限制用户抽中奖品个数
     */
    private Boolean checkLimit;

    /**
     * 用户抽中奖品个数限制
     */
    private Integer limitCount;

    /**
     * 是否校验保底抽奖次数
     */
    private Boolean checkTimes;

    /**
     * 保底抽奖次数
     */
    private Integer minTimes;

    /**
     * 排序权重
     */
    private Integer payload;

    /**
     * 是否删除  0:未删除 1:已删除
     */
    private Boolean deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConfigId() {
        return configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public Integer getRoundIndex() {
        return roundIndex;
    }

    public void setRoundIndex(Integer roundIndex) {
        this.roundIndex = roundIndex;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType == null ? null : prizeType.trim();
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName == null ? null : prizeName.trim();
    }

    public String getPrizeImage() {
        return prizeImage;
    }

    public void setPrizeImage(String prizeImage) {
        this.prizeImage = prizeImage == null ? null : prizeImage.trim();
    }

    public String getPrizeDesc() {
        return prizeDesc;
    }

    public void setPrizeDesc(String prizeDesc) {
        this.prizeDesc = prizeDesc == null ? null : prizeDesc.trim();
    }

    public String getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(String facePrice) {
        this.facePrice = facePrice == null ? null : facePrice.trim();
    }

    public Integer getRemainingStock() {
        return remainingStock;
    }

    public void setRemainingStock(Integer remainingStock) {
        this.remainingStock = remainingStock;
    }

    public Integer getRate() {
        return rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public Boolean getCheckLimit() {
        return checkLimit;
    }

    public void setCheckLimit(Boolean checkLimit) {
        this.checkLimit = checkLimit;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public Boolean getCheckTimes() {
        return checkTimes;
    }

    public void setCheckTimes(Boolean checkTimes) {
        this.checkTimes = checkTimes;
    }

    public Integer getMinTimes() {
        return minTimes;
    }

    public void setMinTimes(Integer minTimes) {
        this.minTimes = minTimes;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}