package cn.com.duiba.activity.center.api.enums;

/**
 * <p>活动渠道枚举</p>
 * <p>created by Xuwei on 2021/4/13<p>
 **/
public enum ActivityChannelTypeEnum {
    NONE(0, "用于兼容，表示没有配置渠道"),

    APP(1, "APP"),
    OFFICIAL_ACCOUNT(2, "微信公众号"),
    MINI_PROGRAM(3, "微信小程序"),
    ;

    private Integer code;
    private String desc;

    ActivityChannelTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityChannelTypeEnum ofCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ActivityChannelTypeEnum obj : values()) {
            if (obj.code.equals(code)) {
                return obj;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
