package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * 日期单位
 * Created by xiaoxuda on 2017/8/11.
 */
public enum DateUnit {
    DAY(1, "天", 1),
    WEEK(2, "周", 7),
    MONTH(3, "月", 31),
    CUSTOM(4, "自定义", -1);

    private static Map<Integer, DateUnit> valueMap = new HashMap<>();
    static{
        for(DateUnit typeEnum : values()){
            valueMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code查询补签类型
     * @param code
     * @return
     */
    public static DateUnit getByCode(Integer code){
        DateUnit type = valueMap.get(code);
        if(type == null){
            throw new ActivityCenterException("不支持的时间类型");
        }
        return type;
    }

    private Integer code;
    private String desc;
    private Integer days;

    DateUnit(Integer code, String desc, Integer days){
        this.code = code;
        this.desc = desc;
        this.days = days;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getDays() {
        return days;
    }
}
