package cn.com.duiba.activity.center.api.enums;


import cn.com.duiba.activity.center.api.exception.ActivityCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2017/5/31.
 */
public enum SignStatusEnum {
    WAIT(0, "等待处理"),
    FAILED(1, "签到失败"),
    SUCCESS(2, "签到成功");

    private static Map<Integer, SignStatusEnum> typeEnumMap = new HashMap<>();

    static {
        for (SignStatusEnum typeEnum : SignStatusEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code获取签到类型
     *
     * @param code
     * @return
     */
    public static SignStatusEnum getByCode(int code) {
        SignStatusEnum type = typeEnumMap.get(code);
        if(type == null){
            throw new ActivityCenterException("不支持的签到状态");
        }
        return type;
    }

    private Integer code;
    private String desc;

    SignStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
