package cn.com.duiba.activity.center.api.remoteservice.diggold;

import cn.com.duiba.activity.center.api.dto.diggold.DigGoldConfigAndPrizesDto;
import cn.com.duiba.activity.center.api.dto.diggold.DigGoldConfigDto;
import cn.com.duiba.activity.center.api.dto.diggold.DigGoldPrizeDto;
import cn.com.duiba.activity.center.api.dto.diggold.DigGoldRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description: 挖金砖活动接口
 * @Date: Created in 2019/7/1
 */
@AdvancedFeignClient
public interface RemoteDigGoldService {

    /**
     * 新建活动配置
     * @param dto
     * @return
     */
    Long insertConfig(DigGoldConfigDto dto);

    /**
     * 新建活动配置(含奖品信息)
     * @param dto
     * @return
     */
    Long insertConfigAndPrizes(DigGoldConfigAndPrizesDto dto);

    /**
     * 修改活动配置
     * @param dto
     * @return
     */
    Boolean updateConfig(DigGoldConfigDto dto);

    /**
     * 修改活动配置(含奖品信息)
     * @param dto
     * @return
     */
    Boolean updateConfigAndPrizes(DigGoldConfigAndPrizesDto dto);

    /**
     * 获取活动配置（含奖品信息）
     * @param id 活动主键id
     * @return
     */
    DigGoldConfigAndPrizesDto getConfigAndPrizes(Long id);

    /**
     * 获取活动配置
     * @param id 活动主键id
     * @return
     */
    DigGoldConfigDto getConfig(Long id);

    /**
     * 获取活动奖品
     * @param configId 活动主键id
     * @return
     */
    List<DigGoldPrizeDto> listPrize(Long configId);

    /**
     * 获取活动奖品列表
     * @param ids 活动奖品主键id
     * @return
     */
    List<DigGoldPrizeDto> listPrizeByIds(List<Long> ids);

    /**
     * 获取活动奖品（包含逻辑被删除的奖品）
     * @param id 活动奖品表主键id
     * @return
     */
    DigGoldPrizeDto getPrizeById(Long id);

    /**
     * 修改奖品剩余数量
     * @param id 活动奖品表主键id
     * @param expectedValue 期望值
     * @param resultValue 结果值
     * @return 只有在期望值满足情况下，才能覆盖成结果值
     */
    boolean CASDecreasePrizeRemind(Long id, int expectedValue, int resultValue);

    /**
     * 批量插入奖品信息
     * @param list
     * @return
     */
    boolean batchInsertPrizes(List<DigGoldPrizeDto> list);

    /**
     * 批量删除奖品信息
     * @param id
     * @return
     */
    boolean batchDeletePrizes(Long id);

    /**
     * 插入参与记录
     * @param dto
     * @return
     */
    Long insertRecord(DigGoldRecordDto dto);

    /**
     * 修改
     * @param dto
     * @return
     */
    boolean updateRecord(DigGoldRecordDto dto);

    /**
     * 通过扣积分订单号查询记录
     * @param orderNum
     * @return
     */
    DigGoldRecordDto getRecord(String orderNum);

    /**
     * 通过记录表主键id查询记录信息
     * @param id
     * @return
     */
    DigGoldRecordDto getRecordById(Long id);

    /**
     * 通过记录表主键ID集合批量获取记录信息
     * @param ids
     * @return
     */
    List<DigGoldRecordDto> listRecords(List<Long> ids);

}
