package cn.com.duiba.activity.center.api.remoteservice.equity;


import cn.com.duiba.activity.center.api.dto.equity.StationStockDto;
import cn.com.duiba.activity.center.api.request.equity.StationStockFindRequest;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteStationStockService {

    Integer save(StationStockDto stationStockDto);

    Integer deleteById(Long id);

    Integer deleteBatchByIds(List<Long> ids);

    Integer updateById(StationStockDto stationStockDto);

    StationStockDto getById(Long id);

    List<StationStockDto> listByIds(List<Long> ids);

    StationStockDto getByUxSidApid(Long appId, Long stationId, Long appItemId) throws BizException;

    List<StationStockDto> listByUxSidApids(Long appId, Long stationId);

    List<StationStockDto> getByAidAndStationIds(Long appId, List<Long> stationIds);

    List<StationStockDto> getByAidAndAppItemIds(Long appId, List<Long> appItemIds);

    List<StationStockDto>  getByCondition(StationStockFindRequest stationStockRequest) throws BizException;

    Integer  getByAppIdAndAppItemCount(StationStockFindRequest stationStockRequest) throws BizException;
}
