package cn.com.duiba.activity.center.api.remoteservice.luckycode;

import cn.com.duiba.activity.center.api.dto.luckycode.LuckyCodeConfigAndAwardDto;
import cn.com.duiba.activity.center.api.dto.luckycode.LuckyCodeConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 幸运码活动配置service
 * author zhanghuifeng
 * date 2019-03-20-15:51
 */
@AdvancedFeignClient
public interface RemoteLuckyCodeConfigService {

    /**
     * 获取幸运码活动配置信息
     * @param id
     * @return
     */
    LuckyCodeConfigDto findById(Long id);

    /**
     * 获取所有生效中的活动
     * @return
     */
    List<LuckyCodeConfigDto> findValid();

    /**
     * 根据活动ID获取活动和奖品配置信息
     * @param id
     * @return
     */
    LuckyCodeConfigAndAwardDto findConfigAndAward(Long id);

    /**
     * 更新活动和奖品配置信息（先将奖品配置进行批量逻辑删除 再进行插入）
     * @return
     */
    Boolean updateConfigAndAward(LuckyCodeConfigAndAwardDto dto);

    /**
     * 新增活动和奖品配置信息
     * @param dto
     * @return
     */
    Boolean addConfigAndAward(LuckyCodeConfigAndAwardDto dto);

    /**
     * 根据入库活动ID查询
     * @param opId
     * @return
     */
    LuckyCodeConfigDto findByOpId(Long opId);

    /**
     * 更新
     * @param dto
     * @return
     */
    Boolean update(LuckyCodeConfigDto dto);

    /**
     * 根据活动ID 查询当前已领奖人数
     * @param id
     * @return
     */
    int findDrawPeopleTotal(Long id);


    /**
     * 根据活动ID增加已领奖人数
     * @param id
     * @return
     */
    Boolean addDrawPeopleTotal(Long id);
}
