package cn.com.duiba.activity.center.api.remoteservice.ngame;


import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameAppSpecifyDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 *
 * ClassName: RemoteDuibaNgameAppSpecifyService <br/>
 * date: 2016年12月1日 下午3:47:52 <br/>
 *
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaNgameAppSpecifyService {

	/**
	 *
	 * findByGameId:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	List<DuibaNgameAppSpecifyDto> findByGameId(Long id);

	/**
	 *
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param id
	 * @since JDK 1.6
	 */
	void delete(Long id);

	/**
	 *
	 * addBatch:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param list
	 * @since JDK 1.6
	 */
	void addBatch(List<DuibaNgameAppSpecifyDto> list);

	/**
	 *
	 * add:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param gameAppSpecifyDO
	 * @return
	 * @since JDK 1.6
	 */
	DuibaNgameAppSpecifyDto add(DuibaNgameAppSpecifyDto gameAppSpecifyDO);

	/**
	 *
	 * findByGameConfigAndAppId:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param appId
	 * @param duibaGameId
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaNgameAppSpecifyDto findByGameConfigAndAppId(Long appId, Long duibaGameId);

	/**
	 *
	 * findByGameConfigAndAppId:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param appId
	 * @param duibaGameIds
	 * @return
	 * @since JDK 1.6
	 */
	@RequestMapping("/findByGameConfigAndAppId1")
	public Map<Long, DuibaNgameAppSpecifyDto> findByGameConfigAndAppId(Long appId, List<Long> duibaGameIds);
}
