package cn.com.duiba.activity.center.api.remoteservice.openredpacket;

import cn.com.duiba.activity.center.api.dto.openredpacket.OpenRedPacketRecordDto;
import cn.com.duiba.activity.center.api.enums.OpenRedPacketRecordStatusEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/4/28 17:13
 * @description: 拆红包工具-拆红包记录
 */
@AdvancedFeignClient
public interface RemoteOpenRedPacketRecordService {

	/**
	 * 新增
	 */
	Long add(OpenRedPacketRecordDto entity, Long openAmount);

	/**
	 * 根据用户id、活动配置id查询拆红包记录list
	 */
	List<OpenRedPacketRecordDto> getListByCidAndConfigId(Long consumerId, Long configId);

	/**
	 * 根据用户id、活动配置id查询进行中的拆红包记录
	 */
	OpenRedPacketRecordDto getUnderWayByCidAndConfigId(Long consumerId, Long configId);

	/**
	 * 根据用户id、活动配置id查询待领取的拆红包记录
	 */
	List<OpenRedPacketRecordDto> getExchangeWaitByCidAndConfigId(Long consumerId, Long configId);

	/**
	 * 根据记录id查询
	 */
	OpenRedPacketRecordDto getById(Long recordId);

	/**
	 * 根据红包码查询
	 */
	OpenRedPacketRecordDto getByCode(String shareCode);

	/**
	 * 更新状态：待领取/已领取/失败
	 */
	int modifyStatus(Long recordId, OpenRedPacketRecordStatusEnum openRedPacketRecordStatusEnum);
}
