package cn.com.duiba.activity.center.api.remoteservice.scraperedpacket;

import cn.com.duiba.activity.center.api.dto.scraperedpacket.ScrapeRedpacketRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteScrapeRedPacketRecordService {

    Long insert(ScrapeRedpacketRecordDto dto);

    ScrapeRedpacketRecordDto findById(Long id);

    /**
     * 根据红包id查询
     * @param redPacketId
     * @return
     */
    List<ScrapeRedpacketRecordDto> findByRedPacketId(Long redPacketId);

    /**
     * 当前活动，当前用户是否帮他人刮过红包
     * @param activityId
     * @param consumerId
     * @return
     */
    boolean selectExistByActIdAndCid(Long activityId, Long consumerId);
}
