package cn.com.duiba.activity.center.api.dto.tlcb;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/6/10 上午9:56
 */
public class TaskConfigDto implements Serializable {

    private static final long serialVersionUID = 3474020916981240434L;
    private Long id;

    /** appId **/
    @NotNull(message = "任务appId不能为空")
    private Long appId;
    /** 活动ID-组件配置id **/
    private Long actId;
    /** 任务唯一键值（前端新建任务时生成） */
    @NotBlank(message = "任务唯一键不能为空")
    private String taskKey;
    /** 任务名 **/
    @NotBlank(message = "任务名不能为空")
    private String taskName;
    /** 任务类型：1-接口任务；2-跳转任务 **/
    @NotNull(message = "任务类型不能为空")
    private Integer taskType;
    /** 是否是阶段性任务，0-否；1-是 **/
    private Integer phaseFlag;
    /** 是否需要解锁前置任务，0-否；1-是 **/
    private Integer lockFlag;
    /** 前置任务key **/
    private String lockTaskKey;
    /** 接口任务-任务标识 **/
    private String taskIdentity;
    /** 选中链接 */
    @NotEmpty(message = "请至少选中其中一项跳转链接")
    private List<String> selectedLinks;
    /** h5跳转链接 **/
    private String linkHtml;
    /** app跳转链接 **/
    private String linkApp;
    /** 小程序id **/
    private String linkMiniAppId;
    /** 小程序路径 **/
    private String linkMiniAppPath;
    /** 奖励类型，积分：1，奖品：2，链接：3 **/
    private Integer awardType;
    /** 积分奖励-积分数 **/
    private Integer creditsNum;
    /** 奖品奖励-商品id **/
    private Long prizeAppItemId;
    /** 奖品奖励-商品类型，object-实物；coupon-优惠券 **/
    private String prizeAppItemType;
    /** 奖品奖励-奖品信息 **/
    private String prizeTitle;
    /** 奖品奖励-剩余奖品数（库存） **/
    private Integer prizeStock;
    /** 链接奖励-链接内容 **/
    private String chainText;
    /** 保底积分 **/
    @NotNull(message = "请输入保底积分数")
    private Integer guaranteedCredits;
    /** 开始时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    /** 结束时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    /** 创建时间 **/
    private Date gmtCreate;
    /** 修改时间 **/
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActId() {
        return actId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public String getTaskKey() {
        return taskKey;
    }

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Integer getPhaseFlag() {
        return phaseFlag;
    }

    public void setPhaseFlag(Integer phaseFlag) {
        this.phaseFlag = phaseFlag;
    }

    public Integer getLockFlag() {
        return lockFlag;
    }

    public void setLockFlag(Integer lockFlag) {
        this.lockFlag = lockFlag;
    }

    public String getLockTaskKey() {
        return lockTaskKey;
    }

    public void setLockTaskKey(String lockTaskKey) {
        this.lockTaskKey = lockTaskKey;
    }

    public String getTaskIdentity() {
        return taskIdentity;
    }

    public void setTaskIdentity(String taskIdentity) {
        this.taskIdentity = taskIdentity;
    }

    public List<String> getSelectedLinks() {
        return selectedLinks;
    }

    public void setSelectedLinks(List<String> selectedLinks) {
        this.selectedLinks = selectedLinks;
    }

    public String getLinkHtml() {
        return linkHtml;
    }

    public void setLinkHtml(String linkHtml) {
        this.linkHtml = linkHtml;
    }

    public String getLinkApp() {
        return linkApp;
    }

    public void setLinkApp(String linkApp) {
        this.linkApp = linkApp;
    }

    public String getLinkMiniAppId() {
        return linkMiniAppId;
    }

    public void setLinkMiniAppId(String linkMiniAppId) {
        this.linkMiniAppId = linkMiniAppId;
    }

    public String getLinkMiniAppPath() {
        return linkMiniAppPath;
    }

    public void setLinkMiniAppPath(String linkMiniAppPath) {
        this.linkMiniAppPath = linkMiniAppPath;
    }

    public Integer getAwardType() {
        return awardType;
    }

    public void setAwardType(Integer awardType) {
        this.awardType = awardType;
    }

    public Integer getCreditsNum() {
        return creditsNum;
    }

    public void setCreditsNum(Integer creditsNum) {
        this.creditsNum = creditsNum;
    }

    public Long getPrizeAppItemId() {
        return prizeAppItemId;
    }

    public void setPrizeAppItemId(Long prizeAppItemId) {
        this.prizeAppItemId = prizeAppItemId;
    }

    public String getPrizeAppItemType() {
        return prizeAppItemType;
    }

    public void setPrizeAppItemType(String prizeAppItemType) {
        this.prizeAppItemType = prizeAppItemType;
    }

    public String getPrizeTitle() {
        return prizeTitle;
    }

    public void setPrizeTitle(String prizeTitle) {
        this.prizeTitle = prizeTitle;
    }

    public Integer getPrizeStock() {
        return prizeStock;
    }

    public void setPrizeStock(Integer prizeStock) {
        this.prizeStock = prizeStock;
    }

    public String getChainText() {
        return chainText;
    }

    public void setChainText(String chainText) {
        this.chainText = chainText;
    }

    public Integer getGuaranteedCredits() {
        return guaranteedCredits;
    }

    public void setGuaranteedCredits(Integer guaranteedCredits) {
        this.guaranteedCredits = guaranteedCredits;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
