package cn.com.duiba.activity.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 种红包活动 红包成熟时间
 * 1-5s、2-10s、3-15s、4-30s、5-60s、6-120s、7-180s、8-300s
 * 第9个开始都是300s
 * Created by hww on 2019/1/28 11:24 AM.
 */
public enum  SeedRedPacketMaturationTimeEnum {

    T01(1, 5L),
    T02(2, 10L),
    T03(3, 15L),
    T04(4, 30L),
    T05(5, 60L),
    T06(6, 120L),
    T07(7, 180L),
    T08(8, 300L),

    ;

    private static final ImmutableMap<Integer, SeedRedPacketMaturationTimeEnum> MAPPING;

    static {
        Map<Integer, SeedRedPacketMaturationTimeEnum> temp = Maps.newHashMap();
        for (SeedRedPacketMaturationTimeEnum s : values()) {
            temp.put(s.serialNumber, s);
        }
        MAPPING = ImmutableMap.copyOf(temp);
    }


    private Integer serialNumber;

    private Long duration;

    SeedRedPacketMaturationTimeEnum(Integer serialNumber, Long duration) {
        this.serialNumber = serialNumber;
        this.duration = duration;
    }

    public Long getDuration() {
        return duration;
    }

    public static long getDurationBySerialNumber(int i) {
        return MAPPING.getOrDefault(i, T08).duration;
    }
}
