package cn.com.duiba.activity.center.api.remoteservice.projectx;

import cn.com.duiba.activity.center.api.dto.projectx.HdtoolProjectActivityRelationDto;
import cn.com.duiba.activity.center.api.dto.projectx.HdtoolProjectTemplateDto;
import cn.com.duiba.activity.center.api.params.CustomizeListParam;
import cn.com.duiba.activity.center.api.params.TemplateListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by hong
 * time 2022/8/10.
 */
@AdvancedFeignClient
public interface RemoteHdtoolProjectActivityRelationService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return FAQ类别集合
     */
    List<HdtoolProjectActivityRelationDto> selectList(CustomizeListParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(CustomizeListParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return FAQ类别
     */
    HdtoolProjectActivityRelationDto selectById(Long id);

    /**
     * 新增
     * @param entity FAQ类别
     * @return 执行结果
     */
    Long insert(HdtoolProjectActivityRelationDto entity);

    /**
     * 更新
     * @param entity FAQ类别
     * @return 执行结果
     */
    Boolean update(HdtoolProjectActivityRelationDto entity);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return FAQ类别集合
     */
    Page<HdtoolProjectActivityRelationDto> selectPage(CustomizeListParam param);

    /**
     * 根据模板查询
     */
    HdtoolProjectActivityRelationDto selectByTemplate(String templateProjectId, Long appId);

    /**
     * 更新关联的入库活动id、星速台项目id
     *
     * @param id
     * @param projectId 星速台项目id
     * @param operatingActivityId 入库活动id
     * @param addSuccess 是否创建成功
     */
    void updateRelationInfo(Long id, String projectId, Long operatingActivityId, boolean addSuccess);

    /**
     * 添加兑吧星速台模板活动到入库活动
     */
    Long addDuibaProjectxTemplateToDeveloper(HdtoolProjectActivityRelationDto activityRelationDto, boolean addSuccess);
}