package cn.com.duiba.activity.center.api.enums.alipayactivityredpack;


import java.util.Objects;

/**
 * @author cjw
 * @version 1.0.0
 * @ClassName RedpackActivityStatus.java
 * @Description 红包活动状态
 * @createTime 2022年11月19日 16:18:00
 */
public enum RedpackActivityStatus {
    REDPACK_ACTIVITY_STATUS_NORNAL(0, "正常"),
    REDPACK_ACTIVITY_STATUS_INVALIDITY(1, "手动失效"),
    REDPACK_ACTIVITY_STATUS_OVERDUE(2, "自动结束"),
    REDPACK_ACTIVITY_STATUS_CREATEING(3, "创建中(中间状态)")
    ;


    private Integer code;
    private String desc;

    RedpackActivityStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static RedpackActivityStatus ofValue(Integer code) {
        for (RedpackActivityStatus redpackActivityStatus : values()) {
            if (Objects.equals(redpackActivityStatus.getCode(), code)) {
                return redpackActivityStatus;
            }
        }
        return null;
    }
}
