/**
 * Project Name:activity-center-api
 * File Name:RemoteTodayRobConfigService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.rob
 * Date:2016年7月25日下午3:21:30
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.littlegame;


import cn.com.duiba.activity.center.api.dto.littlegame.LittleGameDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 小游戏类型 activity-center dubbo接口
 * @author  : cdm
 * @date    : 2016年10月13日 下午2:44:02
 */
@AdvancedFeignClient
public interface RemoteLittleGameService {
	
    /**
     * 
     * getLittleGameById:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID查询游戏信息
     * @param littleGameId
     * @return
     * @since JDK 1.6
     */
    DubboResult<LittleGameDto> getLittleGameById(Long littleGameId);

    /**
     * 
     * customerCutCredits:(这里用一句话描述这个方法的作用). <br/>
     * 扣除积分   ，暂时写在activity-center  理由:迁移方案需讨论
     * @param consumerId
     * @param orderNum
     * @param transfer
     * @param ip
     * @param description
     * @return
     * @since JDK 1.6
     */
    DubboResult<String> customerCutCredits(Long consumerId,String orderNum,String transfer,String ip,String description);
}

