package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-cms-web
 * @description: 核销记录状态举类
 * @author: Simba
 * @create: 2019-09-07 16:07
 **/
public enum VerificationRecordStatusEnum {
    PROCESSING(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    ;
    private Integer code;
    private String desc;

    VerificationRecordStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static VerificationRecordStatusEnum ofValue(Integer code) {
        for (VerificationRecordStatusEnum statusEnum : values()) {
            if (Objects.equals(statusEnum.getCode(), code)) {
                return statusEnum;
            }
        }
        return null;
    }
}

