package cn.com.duiba.activity.center.api.tool;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.params.activitychannel.ActivityChannelConfigParam;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;

/**
 * <p>渠道配置工具类型</p>
 * <p>created by Xuwei on 2021/4/15<p>
 **/
public class ActivityChannelUtils {

    /**
     * 解析获取渠道配置
     * @param op
     * @return
     */
    public static ActivityChannelConfigParam parse(OperatingActivityDto op) {
        if (op == null || StringUtils.isBlank(op.getExtendJson())) {
            return null;
        }
        ActivityChannelWrapper wrapper = JSON.parseObject(op.getExtendJson(), ActivityChannelWrapper.class);
        return wrapper == null ? null : wrapper.getChannelConfig();
    }

    /**
     * 渠道配置包装类，用于解析json
     */
    public static class ActivityChannelWrapper {

        private ActivityChannelConfigParam channelConfig;

        public ActivityChannelConfigParam getChannelConfig() {
            return channelConfig;
        }

        public void setChannelConfig(ActivityChannelConfigParam channelConfig) {
            this.channelConfig = channelConfig;
        }
    }
}
